/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementContainer;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class DeleteElementCommand
extends Command {
    private ElementWrapper child;
    private ElementContainer parent;
    private List<ElementWrapper> incomingElementWrappers = new ArrayList<ElementWrapper>();
    private List<ElementWrapper> outgoingElementWrappers = new ArrayList<ElementWrapper>();
    private List<ElementConnection> incomingConnections = new ArrayList<ElementConnection>();
    private List<ElementConnection> outgoingConnections = new ArrayList<ElementConnection>();

    private void deleteConnections(ElementWrapper element) {
        for (ElementConnection connection : element.getIncomingConnections()) {
            this.incomingElementWrappers.add(connection.getSource());
            this.incomingConnections.add(connection);
        }
        for (ElementConnection connection : element.getOutgoingConnections()) {
            this.outgoingElementWrappers.add(connection.getTarget());
            this.outgoingConnections.add(connection);
        }
        for (ElementConnection connection : this.incomingConnections) {
            connection.disconnect();
        }
        for (ElementConnection connection : this.outgoingConnections) {
            connection.disconnect();
        }
    }

    public void execute() {
        this.deleteConnections(this.child);
        this.parent.removeElement(this.child);
    }

    private void restoreConnections() {
        int i = 0;
        for (ElementConnection connection : this.incomingConnections) {
            connection.connect(this.incomingElementWrappers.get(i), this.child);
            ++i;
        }
        i = 0;
        for (ElementConnection connection : this.outgoingConnections) {
            connection.connect(this.child, this.outgoingElementWrappers.get(i));
            ++i;
        }
        this.incomingConnections.clear();
        this.incomingElementWrappers.clear();
        this.outgoingConnections.clear();
        this.outgoingElementWrappers.clear();
    }

    public void setChild(ElementWrapper child) {
        this.child = child;
    }

    public void setParent(ElementContainer parent) {
        this.parent = parent;
    }

    public void undo() {
        this.parent.addElement(this.child);
        this.restoreConnections();
    }
}

