/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import org.jbpm.process.instance.impl.ReturnValueEvaluator;
import org.kie.api.runtime.process.ProcessContext;

public class XPATHReturnValueEvaluator
implements ReturnValueEvaluator,
Externalizable {
    private static final long serialVersionUID = 510L;
    private String expression;
    private String id;

    public XPATHReturnValueEvaluator() {
    }

    public XPATHReturnValueEvaluator(String expression, String id) {
        this.expression = expression;
        this.id = id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.expression = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.expression);
    }

    public String getDialect() {
        return this.id;
    }

    @Override
    public Object evaluate(final ProcessContext context) throws Exception {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpathEvaluator = factory.newXPath();
        xpathEvaluator.setXPathFunctionResolver(new XPathFunctionResolver(){

            @Override
            public XPathFunction resolveFunction(QName functionName, int arity) {
                String localName = functionName.getLocalPart();
                if ("getVariable".equals(localName)) {
                    return new GetVariableData();
                }
                throw new RuntimeException("Unknown BPMN function: " + functionName);
            }

            class GetVariableData
            implements XPathFunction {
                GetVariableData() {
                }

                public Object evaluate(List args) throws XPathFunctionException {
                    String varname = (String)args.get(0);
                    return context.getVariable(varname);
                }
            }
        });
        xpathEvaluator.setXPathVariableResolver(new XPathVariableResolver(){

            @Override
            public Object resolveVariable(QName variableName) {
                return context.getVariable(variableName.getLocalPart());
            }
        });
        xpathEvaluator.setNamespaceContext(new NamespaceContext(){
            private static final String DROOLS_NAMESPACE_URI = "http://www.jboss.org/drools";
            private String[] prefixes = new String[]{"drools", "bpmn2"};

            public Iterator getPrefixes(String namespaceURI) {
                return Arrays.asList(this.prefixes).iterator();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (DROOLS_NAMESPACE_URI.equalsIgnoreCase(namespaceURI)) {
                    return "bpmn2";
                }
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if ("bpmn2".equalsIgnoreCase(prefix)) {
                    return DROOLS_NAMESPACE_URI;
                }
                return null;
            }
        });
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return xpathEvaluator.evaluate(this.expression, builder.newDocument(), XPathConstants.BOOLEAN);
    }

    public String toString() {
        return this.expression;
    }
}

