/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.actions;

import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.guvnor.tools.Activator;
import org.guvnor.tools.views.model.TreeObject;

public class OpenGuvnorWebConsoleAction
implements IObjectActionDelegate {
    private TreeObject selectedNode;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.selectedNode == null) {
            return;
        }
        IWorkbenchBrowserSupport browserSupport = Activator.getDefault().getWorkbench().getBrowserSupport();
        try {
            URL consoleURL = new URL(this.extractGuvnorConsoleUrl(this.selectedNode.getGuvnorRepository().getLocation()));
            if (browserSupport.isInternalWebBrowserAvailable()) {
                browserSupport.createBrowser(null).openURL(consoleURL);
            } else {
                browserSupport.getExternalBrowser().openURL(consoleURL);
            }
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
    }

    private String extractGuvnorConsoleUrl(String guvnorLoc) {
        String id = "/webdav";
        int pos = guvnorLoc.indexOf(id);
        if (pos == -1) {
            return String.valueOf(guvnorLoc) + "/Guvnor.html";
        }
        return String.valueOf(guvnorLoc.substring(0, pos)) + "/Guvnor.html";
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() != 1) {
            return;
        }
        if (sel.getFirstElement() instanceof TreeObject && ((TreeObject)sel.getFirstElement()).getNodeType() == TreeObject.Type.REPOSITORY) {
            this.selectedNode = (TreeObject)sel.getFirstElement();
            action.setEnabled(true);
        }
    }
}

