/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.jtms;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSet;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.core.beliefsystem.jtms.JTMSMode;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ObjectTypeConfigurationRegistry;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;

public class JTMSBeliefSystem<M extends JTMSMode<M>>
implements BeliefSystem<M> {
    public static boolean STRICT = false;
    private TruthMaintenanceSystem tms;
    protected NamedEntryPoint defEP;
    protected NamedEntryPoint negEP;

    public JTMSBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.defEP = ep;
        this.tms = tms;
        this.initMainEntryPoints();
    }

    private void initMainEntryPoints() {
        this.negEP = (NamedEntryPoint)this.defEP.getWorkingMemoryEntryPoint(JTMSBeliefSetImpl.MODE.NEGATIVE.getId());
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public void insert(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        JTMSBeliefSet jtmsBeliefSet = (JTMSBeliefSet)beliefSet;
        boolean wasEmpty = jtmsBeliefSet.isEmpty();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        boolean wasUndecided = jtmsBeliefSet.isUndecided();
        jtmsBeliefSet.add(node.getMode());
        if (wasEmpty) {
            if (!jtmsBeliefSet.isUndecided()) {
                this.insertBelief(node, typeConf, jtmsBeliefSet, context, wasEmpty, wasNegated, wasUndecided);
            } else {
                this.defEP.getObjectStore().removeHandle(jtmsBeliefSet.getFactHandle());
            }
        } else if (!wasUndecided && jtmsBeliefSet.isUndecided()) {
            if (STRICT) {
                throw new IllegalStateException("FATAL : A fact and its negation have been asserted " + jtmsBeliefSet.getFactHandle().getObject());
            }
            this.deleteAfterChangedEntryPoint(node, context, typeConf, jtmsBeliefSet, wasNegated);
        } else if (wasUndecided && !jtmsBeliefSet.isUndecided()) {
            this.insertBelief(node, typeConf, jtmsBeliefSet, context, wasEmpty, wasNegated, wasUndecided);
        }
    }

    private void deleteAfterChangedEntryPoint(LogicalDependency<M> node, PropagationContext context, ObjectTypeConf typeConf, JTMSBeliefSet<M> jtmsBeliefSet, boolean wasNegated) {
        if (wasNegated) {
            InternalFactHandle fh = jtmsBeliefSet.getNegativeFactHandle();
            jtmsBeliefSet.setNegativeFactHandle(null);
            ((NamedEntryPoint)fh.getEntryPoint()).delete(fh, context.getRuleOrigin(), node.getJustifier());
        } else {
            InternalFactHandle fh = jtmsBeliefSet.getPositiveFactHandle();
            jtmsBeliefSet.setPositiveFactHandle(null);
            NamedEntryPoint nep = (NamedEntryPoint)fh.getEntryPoint();
            nep.getEntryPointNode().retractObject(fh, context, typeConf, nep.getInternalWorkingMemory());
        }
    }

    protected void insertBelief(LogicalDependency<M> node, ObjectTypeConf typeConf, JTMSBeliefSet<M> jtmsBeliefSet, PropagationContext context, boolean wasEmpty, boolean wasNegated, boolean isUndecided) {
        if (jtmsBeliefSet.isNegated() && !jtmsBeliefSet.isUndecided()) {
            jtmsBeliefSet.setNegativeFactHandle((InternalFactHandle)this.negEP.insert(node.getObject()));
            jtmsBeliefSet.getNegativeFactHandle().setEqualityKey(jtmsBeliefSet.getFactHandle().getEqualityKey());
            jtmsBeliefSet.setPositiveFactHandle(null);
            if (!wasNegated && !isUndecided) {
                this.defEP.getObjectStore().removeHandle(jtmsBeliefSet.getFactHandle());
            }
        } else if (jtmsBeliefSet.isPositive() && !jtmsBeliefSet.isUndecided()) {
            jtmsBeliefSet.setPositiveFactHandle(jtmsBeliefSet.getFactHandle());
            jtmsBeliefSet.setNegativeFactHandle(null);
            if (!wasEmpty && (wasNegated || isUndecided)) {
                jtmsBeliefSet.getFactHandle().setObject(node.getObject());
                this.defEP.getObjectStore().addHandle(jtmsBeliefSet.getPositiveFactHandle(), jtmsBeliefSet.getPositiveFactHandle().getObject());
            }
            if (typeConf == null) {
                typeConf = this.getObjectTypeConf(jtmsBeliefSet, false);
            }
            this.defEP.insert(jtmsBeliefSet.getPositiveFactHandle(), node.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf, null);
        }
    }

    @Override
    public void read(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        throw new UnsupportedOperationException("This is not serializable yet");
    }

    @Override
    public void delete(LogicalDependency<M> node, BeliefSet<M> beliefSet, PropagationContext context) {
        JTMSBeliefSet jtmsBeliefSet = (JTMSBeliefSet)beliefSet;
        boolean wasUndecided = jtmsBeliefSet.isUndecided();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        boolean primeChanged = false;
        if (jtmsBeliefSet.getPositiveFactHandle() != null && jtmsBeliefSet.getPositiveFactHandle().getObject() == node.getObject() || jtmsBeliefSet.getNegativeFactHandle() != null && jtmsBeliefSet.getNegativeFactHandle().getObject() == node.getObject()) {
            primeChanged = true;
        }
        beliefSet.remove(node.getMode());
        if (beliefSet.isEmpty()) {
            InternalFactHandle fh;
            if (wasNegated && !wasUndecided) {
                this.defEP.getObjectStore().addHandle(beliefSet.getFactHandle(), beliefSet.getFactHandle().getObject());
                fh = jtmsBeliefSet.getNegativeFactHandle();
                ((NamedEntryPoint)fh.getEntryPoint()).delete(fh, context.getRuleOrigin(), node.getJustifier());
            }
            if (context.getType() != 1 || context.getFactHandle() != beliefSet.getFactHandle()) {
                fh = jtmsBeliefSet.getFactHandle();
                ((NamedEntryPoint)fh.getEntryPoint()).delete(fh, context.getRuleOrigin(), node.getJustifier());
            }
        } else if (wasUndecided && !jtmsBeliefSet.isUndecided()) {
            this.insertBelief(node, this.defEP.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.defEP.getEntryPoint(), node.getObject()), jtmsBeliefSet, context, false, wasNegated, wasUndecided);
        } else if (primeChanged) {
            if (wasNegated && !jtmsBeliefSet.isNegated() || !wasNegated && jtmsBeliefSet.isNegated()) {
                ObjectTypeConf typeConf = this.getObjectTypeConf(jtmsBeliefSet, wasNegated);
                this.deleteAfterChangedEntryPoint(node, context, typeConf, jtmsBeliefSet, wasNegated);
                typeConf = null;
                this.insertBelief(node, typeConf, jtmsBeliefSet, context, false, wasNegated, wasUndecided);
            } else {
                Object object = null;
                InternalFactHandle fh = null;
                if (jtmsBeliefSet.isNegated()) {
                    String value = JTMSBeliefSetImpl.MODE.NEGATIVE.getId();
                    fh = jtmsBeliefSet.getNegativeFactHandle();
                    for (JTMSMode entry = (JTMSMode)jtmsBeliefSet.getLast(); entry != null; entry = (JTMSMode)entry.getPrevious()) {
                        if (!entry.getValue().equals(value)) continue;
                        object = entry.getLogicalDependency().getObject();
                        break;
                    }
                } else {
                    String value = JTMSBeliefSetImpl.MODE.POSITIVE.getId();
                    fh = jtmsBeliefSet.getPositiveFactHandle();
                    for (JTMSMode entry = (JTMSMode)jtmsBeliefSet.getFirst(); entry != null; entry = (JTMSMode)entry.getNext()) {
                        if (entry.getValue() != null && !entry.getValue().equals(value)) continue;
                        object = entry.getLogicalDependency().getObject();
                        break;
                    }
                }
                if (fh.getObject() != object) {
                    ((NamedEntryPoint)fh.getEntryPoint()).getObjectStore().updateHandle(fh, object);
                    ((NamedEntryPoint)fh.getEntryPoint()).update(fh, true, fh.getObject(), Long.MAX_VALUE, object.getClass(), null);
                }
            }
        }
    }

    private ObjectTypeConf getObjectTypeConf(JTMSBeliefSet<M> jtmsBeliefSet, boolean neg) {
        InternalFactHandle fh = neg ? jtmsBeliefSet.getNegativeFactHandle() : jtmsBeliefSet.getPositiveFactHandle();
        NamedEntryPoint nep = (NamedEntryPoint)fh.getEntryPoint();
        ObjectTypeConfigurationRegistry reg = nep.getObjectTypeConfigurationRegistry();
        ObjectTypeConf typeConf = reg.getObjectTypeConf(nep.getEntryPoint(), fh.getObject());
        return typeConf;
    }

    @Override
    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new JTMSBeliefSetImpl(this, fh);
    }

    @Override
    public LogicalDependency newLogicalDependency(Activation<M> activation, BeliefSet<M> beliefSet, Object object, Object value) {
        JTMSMode mode = value == null ? new JTMSMode(JTMSBeliefSetImpl.MODE.POSITIVE.getId(), this) : (value instanceof String ? (JTMSBeliefSetImpl.MODE.POSITIVE.getId().equals(value) ? new JTMSMode(JTMSBeliefSetImpl.MODE.POSITIVE.getId(), this) : new JTMSMode(JTMSBeliefSetImpl.MODE.NEGATIVE.getId(), this)) : new JTMSMode(((JTMSBeliefSetImpl.MODE)((Object)value)).getId(), this));
        SimpleLogicalDependency dep = new SimpleLogicalDependency(activation, beliefSet, object, mode);
        mode.setLogicalDependency(dep);
        return dep;
    }
}

