/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.core.beliefsystem.ModedAssertion;
import org.drools.core.beliefsystem.simple.SimpleMode;
import org.drools.core.common.ActivationGroupNode;
import org.drools.core.common.ActivationNode;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.QueryElementFactHandle;
import org.drools.core.definitions.rule.impl.RuleImpl;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.GroupElement;
import org.drools.core.spi.Consequence;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.event.rule.ActivationUnMatchListener;

public class AgendaItemImpl<T extends ModedAssertion<T>>
implements AgendaItem<T> {
    private static final long serialVersionUID = 510L;
    private LeftTuple tuple;
    private int salience;
    private TerminalNode rtn;
    private PropagationContext context;
    private long activationNumber;
    private volatile int index;
    private volatile boolean queued;
    private LinkedList<LogicalDependency<T>> justified;
    private LinkedList<LogicalDependency<SimpleMode>> blocked;
    private LinkedList<SimpleMode> blockers;
    private InternalAgendaGroup agendaGroup;
    private ActivationGroupNode activationGroupNode;
    private ActivationNode activationNode;
    private InternalFactHandle factHandle;
    private transient boolean canceled;
    private boolean matched;
    private boolean active;
    private ActivationUnMatchListener activationUnMatchListener;

    public AgendaItemImpl() {
    }

    public AgendaItemImpl(long activationNumber, LeftTuple tuple, int salience, PropagationContext context, TerminalNode rtn, InternalAgendaGroup agendaGroup) {
        this.tuple = tuple;
        this.context = context;
        this.salience = salience;
        this.rtn = rtn;
        this.activationNumber = activationNumber;
        this.index = -1;
        this.matched = true;
        this.agendaGroup = agendaGroup;
    }

    @Override
    public PropagationContext getPropagationContext() {
        return this.context;
    }

    @Override
    public void setPropagationContext(PropagationContext context) {
        this.context = context;
    }

    @Override
    public RuleImpl getRule() {
        return this.rtn.getRule();
    }

    @Override
    public Consequence getConsequence() {
        String consequenceName = ((RuleTerminalNode)this.rtn).getConsequenceName();
        return consequenceName.equals("default") ? this.rtn.getRule().getConsequence() : this.rtn.getRule().getNamedConsequence(consequenceName);
    }

    @Override
    public LeftTuple getTuple() {
        return this.tuple;
    }

    @Override
    public int getSalience() {
        return this.salience;
    }

    @Override
    public void setSalience(int salience) {
        this.salience = salience;
    }

    @Override
    public InternalFactHandle getFactHandle() {
        return this.factHandle;
    }

    @Override
    public void setFactHandle(InternalFactHandle factHandle) {
        this.factHandle = factHandle;
    }

    @Override
    public RuleAgendaItem getRuleAgendaItem() {
        return null;
    }

    @Override
    public long getActivationNumber() {
        return this.activationNumber;
    }

    @Override
    public void addBlocked(LogicalDependency<SimpleMode> dep) {
        if (this.blocked == null) {
            this.blocked = new LinkedList();
        }
        this.blocked.add(dep);
        AgendaItemImpl blocked = (AgendaItemImpl)dep.getJustified();
        if (blocked.blockers == null) {
            blocked.blockers = new LinkedList();
            blocked.blockers.add(dep.getMode());
        } else if (dep.getMode().getNext() == null && dep.getMode().getPrevious() == null && blocked.getBlockers().getFirst() != dep.getMode()) {
            blocked.blockers.add(dep.getMode());
        }
    }

    @Override
    public void removeAllBlockersAndBlocked(InternalAgenda agenda) {
        if (this.blockers != null) {
            for (LinkedListEntry node = (LinkedListEntry)this.blockers.getFirst(); node != null; node = (LinkedListEntry)node.getNext()) {
                LogicalDependency dep = (LogicalDependency)node.getObject();
                dep.getJustifier().getBlocked().remove(dep);
            }
        }
        this.blockers = null;
        if (this.blocked != null) {
            LogicalDependency dep = this.blocked.getFirst();
            while (dep != null) {
                LogicalDependency tmp = (LogicalDependency)dep.getNext();
                this.removeBlocked(dep);
                AgendaItem justified = (AgendaItem)dep.getJustified();
                if (justified.getBlockers().isEmpty()) {
                    agenda.stageLeftTuple(null, justified);
                }
                dep = tmp;
            }
        }
        this.blocked = null;
    }

    @Override
    public void removeBlocked(LogicalDependency<SimpleMode> dep) {
        this.blocked.remove(dep);
        AgendaItemImpl blocked = (AgendaItemImpl)dep.getJustified();
        blocked.blockers.remove(dep.getMode());
    }

    @Override
    public LinkedList<LogicalDependency<SimpleMode>> getBlocked() {
        return this.blocked;
    }

    @Override
    public void setBlocked(LinkedList<LogicalDependency<SimpleMode>> justified) {
        this.blocked = justified;
    }

    @Override
    public LinkedList<SimpleMode> getBlockers() {
        return this.blockers;
    }

    @Override
    public void addLogicalDependency(LogicalDependency<T> node) {
        if (this.justified == null) {
            this.justified = new LinkedList();
        }
        this.justified.add(node);
    }

    @Override
    public LinkedList<LogicalDependency<T>> getLogicalDependencies() {
        return this.justified;
    }

    @Override
    public void setLogicalDependencies(LinkedList<LogicalDependency<T>> justified) {
        this.justified = justified;
    }

    @Override
    public boolean isQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    @Override
    public String toString() {
        return "[Activation rule=" + this.rtn.getRule().getName() + ", act#=" + this.activationNumber + ", salience=" + this.salience + ", tuple=" + this.tuple + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AgendaItemImpl)) {
            return false;
        }
        AgendaItem otherItem = (AgendaItem)object;
        return this.rtn.getRule().equals(otherItem.getRule()) && this.tuple.equals(otherItem.getTuple());
    }

    @Override
    public int hashCode() {
        return this.tuple.hashCode();
    }

    @Override
    public void setQueueIndex(int index) {
        this.index = index;
    }

    @Override
    public void dequeue() {
        if (this.agendaGroup != null) {
            this.agendaGroup.remove(this);
        }
        this.queued = false;
    }

    @Override
    public int getQueueIndex() {
        return this.index;
    }

    @Override
    public void remove() {
        this.dequeue();
    }

    @Override
    public ActivationGroupNode getActivationGroupNode() {
        return this.activationGroupNode;
    }

    @Override
    public void setActivationGroupNode(ActivationGroupNode activationNode) {
        this.activationGroupNode = activationNode;
    }

    @Override
    public InternalAgendaGroup getAgendaGroup() {
        return this.agendaGroup;
    }

    @Override
    public ActivationNode getActivationNode() {
        return this.activationNode;
    }

    @Override
    public void setActivationNode(ActivationNode activationNode) {
        this.activationNode = activationNode;
    }

    @Override
    public GroupElement getSubRule() {
        return this.rtn.getSubRule();
    }

    @Override
    public TerminalNode getTerminalNode() {
        return this.rtn;
    }

    @Override
    public ActivationUnMatchListener getActivationUnMatchListener() {
        return this.activationUnMatchListener;
    }

    @Override
    public void setActivationUnMatchListener(ActivationUnMatchListener activationUnMatchListener) {
        this.activationUnMatchListener = activationUnMatchListener;
    }

    @Override
    public List<FactHandle> getFactHandles() {
        InternalFactHandle[] factHandles = this.tuple.toFactHandles();
        ArrayList<InternalFactHandle> list = new ArrayList<InternalFactHandle>(factHandles.length);
        for (InternalFactHandle factHandle : factHandles) {
            Object o = factHandle.getObject();
            if (o instanceof QueryElementFactHandle) continue;
            list.add(factHandle);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public String toExternalForm() {
        return "[ " + this.getRule().getName() + " active=" + this.queued + " ]";
    }

    @Override
    public List<Object> getObjects() {
        InternalFactHandle[] factHandles = this.tuple.toFactHandles();
        ArrayList<Object> list = new ArrayList<Object>(factHandles.length);
        int j = 0;
        for (InternalFactHandle factHandle : factHandles) {
            Object o = factHandle.getObject();
            list.set(j++, o instanceof QueryElementFactHandle ? null : o);
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Object getDeclarationValue(String variableName) {
        Declaration decl = this.rtn.getSubRule().getOuterDeclarations().get(variableName);
        InternalFactHandle handle = this.tuple.get(decl);
        return decl.getValue(null, handle.getObject());
    }

    @Override
    public List<String> getDeclarationIds() {
        Declaration[] declArray = ((RuleTerminalNode)this.tuple.getLeftTupleSink()).getDeclarations();
        ArrayList<String> declarations = new ArrayList<String>();
        for (Declaration decl : declArray) {
            declarations.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(declarations);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public boolean isMatched() {
        return this.matched;
    }

    @Override
    public void setMatched(boolean matched) {
        this.matched = matched;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean isRuleAgendaItem() {
        return false;
    }
}

