/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.common;

import org.drools.core.common.TupleEntryQueue;
import org.drools.core.phreak.TupleEntry;

public class TupleEntryQueueImpl
implements TupleEntryQueue {
    private volatile int size = 0;
    private TupleEntry head;
    private TupleEntry tail;

    @Override
    public synchronized boolean add(TupleEntry entry) {
        if (this.head == null) {
            this.head = entry;
            this.tail = entry;
        } else {
            this.tail.setNext(entry);
            this.tail = entry;
        }
        return this.size++ == 0;
    }

    @Override
    public TupleEntry peek() {
        return this.head;
    }

    @Override
    public synchronized TupleEntry remove() {
        TupleEntry entry = this.head;
        this.head = this.head.getNext();
        --this.size;
        return entry;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public synchronized TupleEntryQueueImpl takeAll() {
        TupleEntryQueueImpl clone = new TupleEntryQueueImpl();
        clone.head = this.head;
        clone.tail = this.tail;
        clone.size = this.size;
        this.head = null;
        this.tail = null;
        this.size = 0;
        return clone;
    }
}

