/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.rule;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.core.rule.ConditionalElement;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.kie.api.runtime.rule.Variable;

public class QueryElement
extends ConditionalElement
implements Externalizable {
    private Pattern resultPattern;
    private String queryName;
    private Object[] argTemplate;
    private int[] declIndexes;
    private int[] variableIndexes;
    private boolean openQuery;
    private boolean abductive;
    private Declaration[] requiredDeclarations;

    public QueryElement() {
    }

    public QueryElement(Pattern resultPattern, String queryName, Object[] argTemplate, Declaration[] requiredDeclarations, int[] declIndexes, int[] variableIndexes, boolean openQuery, boolean abductive) {
        this.resultPattern = resultPattern;
        this.queryName = queryName;
        this.argTemplate = argTemplate;
        this.requiredDeclarations = requiredDeclarations;
        this.declIndexes = declIndexes;
        this.variableIndexes = variableIndexes;
        this.openQuery = openQuery;
        this.abductive = abductive;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.resultPattern);
        out.writeObject(this.queryName);
        out.writeObject(this.argTemplate);
        out.writeObject(this.requiredDeclarations);
        out.writeObject(this.declIndexes);
        out.writeObject(this.variableIndexes);
        out.writeBoolean(this.openQuery);
        out.writeBoolean(this.abductive);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.resultPattern = (Pattern)in.readObject();
        this.queryName = (String)in.readObject();
        this.argTemplate = (Object[])in.readObject();
        for (int i = 0; i < this.argTemplate.length; ++i) {
            if (!(this.argTemplate[i] instanceof Variable)) continue;
            this.argTemplate[i] = Variable.v;
        }
        this.requiredDeclarations = (Declaration[])in.readObject();
        this.declIndexes = (int[])in.readObject();
        this.variableIndexes = (int[])in.readObject();
        this.openQuery = in.readBoolean();
        this.abductive = in.readBoolean();
    }

    public String getQueryName() {
        return this.queryName;
    }

    public Object[] getArgTemplate() {
        return this.argTemplate;
    }

    public int[] getDeclIndexes() {
        return this.declIndexes;
    }

    public void setVariableIndexes(int[] varIndexes) {
        this.variableIndexes = varIndexes;
    }

    public int[] getVariableIndexes() {
        return this.variableIndexes;
    }

    public Map getInnerDeclarations() {
        return this.resultPattern.getInnerDeclarations();
    }

    public Map getOuterDeclarations() {
        return this.resultPattern.getOuterDeclarations();
    }

    public List getNestedElements() {
        return Collections.EMPTY_LIST;
    }

    public Pattern getResultPattern() {
        return this.resultPattern;
    }

    @Override
    public boolean isPatternScopeDelimiter() {
        return true;
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public boolean isOpenQuery() {
        return this.openQuery;
    }

    public boolean isAbductive() {
        return this.abductive;
    }

    @Override
    public Declaration resolveDeclaration(String identifier) {
        return this.resultPattern.resolveDeclaration(identifier);
    }

    @Override
    public QueryElement clone() {
        return new QueryElement(this.resultPattern.clone(), this.queryName, this.argTemplate, this.requiredDeclarations, this.declIndexes, this.variableIndexes, this.openQuery, this.abductive);
    }

    public String toString() {
        return "QueryElement [resultPattern=" + this.resultPattern + ", queryName=" + this.queryName + ", argTemplate=" + Arrays.toString(this.argTemplate) + ", declIndexes=" + Arrays.toString(this.declIndexes) + ", variableIndexes=" + Arrays.toString(this.variableIndexes) + ", openQuery=" + this.openQuery + ", abductive=" + this.abductive + ", requiredDeclarations=" + Arrays.toString(this.requiredDeclarations) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.argTemplate);
        result = 31 * result + Arrays.hashCode(this.declIndexes);
        result = 31 * result + (this.openQuery ? 1231 : 1237);
        result = 31 * result + (this.abductive ? 1231 : 1237);
        result = 31 * result + (this.queryName == null ? 0 : this.queryName.hashCode());
        result = 31 * result + Arrays.hashCode(this.requiredDeclarations);
        result = 31 * result + (this.resultPattern == null ? 0 : this.resultPattern.hashCode());
        result = 31 * result + Arrays.hashCode(this.variableIndexes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryElement other = (QueryElement)obj;
        if (!Arrays.equals(this.argTemplate, other.argTemplate)) {
            return false;
        }
        if (!Arrays.equals(this.declIndexes, other.declIndexes)) {
            return false;
        }
        if (this.openQuery != other.openQuery) {
            return false;
        }
        if (this.abductive != other.abductive) {
            return false;
        }
        if (this.queryName == null ? other.queryName != null : !this.queryName.equals(other.queryName)) {
            return false;
        }
        if (!Arrays.equals(this.requiredDeclarations, other.requiredDeclarations)) {
            return false;
        }
        if (this.resultPattern == null ? other.resultPattern != null : !this.resultPattern.equals(other.resultPattern)) {
            return false;
        }
        return Arrays.equals(this.variableIndexes, other.variableIndexes);
    }
}

