/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import org.drools.persistence.PersistenceContext;
import org.drools.persistence.info.SessionInfo;
import org.drools.persistence.info.WorkItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaPersistenceContext
implements PersistenceContext {
    private static Logger logger = LoggerFactory.getLogger(JpaPersistenceContext.class);
    private EntityManager em;
    protected final boolean isJTA;
    protected final boolean pessimisticLocking;

    public JpaPersistenceContext(EntityManager em) {
        this(em, true, false);
    }

    public JpaPersistenceContext(EntityManager em, boolean isJTA) {
        this(em, isJTA, false);
    }

    public JpaPersistenceContext(EntityManager em, boolean isJTA, boolean locking) {
        this.em = em;
        this.isJTA = isJTA;
        this.pessimisticLocking = locking;
    }

    @Override
    public SessionInfo persist(SessionInfo entity) {
        this.em.persist((Object)entity);
        if (this.pessimisticLocking) {
            return (SessionInfo)this.em.find(SessionInfo.class, (Object)entity.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return entity;
    }

    @Override
    public SessionInfo findSessionInfo(Integer id) {
        if (this.pessimisticLocking) {
            return (SessionInfo)this.em.find(SessionInfo.class, (Object)id, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return (SessionInfo)this.em.find(SessionInfo.class, (Object)id);
    }

    @Override
    public void remove(SessionInfo sessionInfo) {
        this.em.remove((Object)sessionInfo);
        this.em.flush();
    }

    public void lock(SessionInfo sessionInfo) {
        this.em.lock((Object)sessionInfo, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    @Override
    public boolean isOpen() {
        return this.em.isOpen();
    }

    @Override
    public void joinTransaction() {
        if (this.isJTA) {
            this.em.joinTransaction();
        }
    }

    @Override
    public void close() {
        this.em.close();
    }

    @Override
    public WorkItemInfo persist(WorkItemInfo workItemInfo) {
        this.em.persist((Object)workItemInfo);
        if (this.pessimisticLocking) {
            return (WorkItemInfo)this.em.find(WorkItemInfo.class, (Object)workItemInfo.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return workItemInfo;
    }

    @Override
    public WorkItemInfo findWorkItemInfo(Long id) {
        if (this.pessimisticLocking) {
            return (WorkItemInfo)this.em.find(WorkItemInfo.class, (Object)id, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
        }
        return (WorkItemInfo)this.em.find(WorkItemInfo.class, (Object)id);
    }

    @Override
    public void remove(WorkItemInfo workItemInfo) {
        this.em.remove((Object)workItemInfo);
    }

    @Override
    public WorkItemInfo merge(WorkItemInfo workItemInfo) {
        if (this.pessimisticLocking) {
            if (this.em.contains((Object)workItemInfo)) {
                this.em.lock((Object)workItemInfo, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
            } else {
                WorkItemInfo dbWorkItemInfo = (WorkItemInfo)this.em.find(WorkItemInfo.class, (Object)workItemInfo.getId(), LockModeType.PESSIMISTIC_FORCE_INCREMENT);
                for (Field field : WorkItemInfo.class.getDeclaredFields()) {
                    boolean access = field.isAccessible();
                    field.setAccessible(true);
                    try {
                        field.set(dbWorkItemInfo, field.get(workItemInfo));
                    }
                    catch (Exception e) {
                        logger.error("Unable to set field " + field.getName() + " of unmerged WorkItemInfo instance!", (Throwable)e);
                    }
                    field.setAccessible(access);
                }
            }
        }
        return (WorkItemInfo)this.em.merge((Object)workItemInfo);
    }

    @Override
    public void lock(WorkItemInfo workItemInfo) {
        this.em.lock((Object)workItemInfo, LockModeType.PESSIMISTIC_FORCE_INCREMENT);
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }
}

