/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.util.CTColComparator;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class ColumnHelper {
    private CTWorksheet worksheet;
    private CTCols newCols;

    public ColumnHelper(CTWorksheet worksheet) {
        this.worksheet = worksheet;
        this.cleanColumns();
    }

    public void cleanColumns() {
        this.newCols = CTCols.Factory.newInstance();
        CTCols aggregateCols = CTCols.Factory.newInstance();
        List colsList = this.worksheet.getColsList();
        if (colsList != null) {
            for (CTCols cols : colsList) {
                for (CTCol col : cols.getColList()) {
                    this.cloneCol(aggregateCols, col);
                }
            }
        }
        ColumnHelper.sortColumns(aggregateCols);
        CTCol[] colArray = new CTCol[aggregateCols.getColList().size()];
        aggregateCols.getColList().toArray(colArray);
        this.sweepCleanColumns(this.newCols, colArray, null);
        int i = colsList.size();
        for (int y = i - 1; y >= 0; --y) {
            this.worksheet.removeCols(y);
        }
        this.worksheet.addNewCols();
        this.worksheet.setColsArray(0, this.newCols);
    }

    private void sweepCleanColumns(CTCols cols, CTCol[] flattenedColsArray, CTCol overrideColumn) {
        ArrayList<CTCol> flattenedCols = new ArrayList<CTCol>(Arrays.asList(flattenedColsArray));
        TreeSet<CTCol> currentElements = new TreeSet<CTCol>(new CTColByMaxComparator());
        ListIterator flIter = flattenedCols.listIterator();
        CTCol haveOverrideColumn = null;
        long lastMaxIndex = 0L;
        long currentMax = 0L;
        while (flIter.hasNext()) {
            CTCol elem;
            long nextIndex;
            CTCol col = (CTCol)flIter.next();
            long currentIndex = col.getMin();
            long l = nextIndex = col.getMax() > currentMax ? col.getMax() : currentMax;
            if (flIter.hasNext()) {
                nextIndex = ((CTCol)flIter.next()).getMin();
                flIter.previous();
            }
            Iterator<CTCol> iter = currentElements.iterator();
            while (iter.hasNext() && currentIndex > (elem = iter.next()).getMax()) {
                iter.remove();
            }
            if (!currentElements.isEmpty() && lastMaxIndex < currentIndex) {
                this.insertCol(cols, lastMaxIndex, currentIndex - 1L, currentElements.toArray(new CTCol[0]), true, haveOverrideColumn);
            }
            currentElements.add(col);
            if (col.getMax() > currentMax) {
                currentMax = col.getMax();
            }
            if (col.equals(overrideColumn)) {
                haveOverrideColumn = overrideColumn;
            }
            while (currentIndex <= nextIndex && !currentElements.isEmpty()) {
                CTCol cc;
                HashSet<CTCol> currentIndexElements = new HashSet<CTCol>();
                CTCol currentElem = currentElements.first();
                long currentElemIndex = currentElem.getMax();
                currentIndexElements.add(currentElem);
                Iterator i$ = currentElements.tailSet(currentElem).iterator();
                while (i$.hasNext() && (cc = (CTCol)i$.next()) != null && cc.getMax() != currentElemIndex) {
                    currentIndexElements.add(cc);
                    if (col.getMax() > currentMax) {
                        currentMax = col.getMax();
                    }
                    if (!col.equals(overrideColumn)) continue;
                    haveOverrideColumn = overrideColumn;
                }
                if (currentElemIndex < nextIndex || !flIter.hasNext()) {
                    this.insertCol(cols, currentIndex, currentElemIndex, currentElements.toArray(new CTCol[0]), true, haveOverrideColumn);
                    if (flIter.hasNext()) {
                        if (nextIndex > currentElemIndex) {
                            currentElements.removeAll(currentIndexElements);
                            if (currentIndexElements.contains(overrideColumn)) {
                                haveOverrideColumn = null;
                            }
                        }
                    } else {
                        currentElements.removeAll(currentIndexElements);
                        if (currentIndexElements.contains(overrideColumn)) {
                            haveOverrideColumn = null;
                        }
                    }
                    lastMaxIndex = currentIndex = currentElemIndex + 1L;
                    continue;
                }
                lastMaxIndex = currentIndex;
                currentIndex = nextIndex + 1L;
            }
        }
        ColumnHelper.sortColumns(cols);
    }

    public static void sortColumns(CTCols newCols) {
        CTCol[] colArray = new CTCol[newCols.getColList().size()];
        newCols.getColList().toArray(colArray);
        Arrays.sort(colArray, new CTColComparator());
        newCols.setColArray(colArray);
    }

    public CTCol cloneCol(CTCols cols, CTCol col) {
        CTCol newCol = cols.addNewCol();
        newCol.setMin(col.getMin());
        newCol.setMax(col.getMax());
        this.setColumnAttributes(col, newCol);
        return newCol;
    }

    public CTCol getColumn(long index, boolean splitColumns) {
        return this.getColumn1Based(index + 1L, splitColumns);
    }

    public CTCol getColumn1Based(long index1, boolean splitColumns) {
        CTCols colsArray = this.worksheet.getColsArray(0);
        for (int i = 0; i < colsArray.sizeOfColArray(); ++i) {
            CTCol colArray = colsArray.getColArray(i);
            if (colArray.getMin() > index1 || colArray.getMax() < index1) continue;
            if (splitColumns) {
                if (colArray.getMin() < index1) {
                    this.insertCol(colsArray, colArray.getMin(), index1 - 1L, new CTCol[]{colArray});
                }
                if (colArray.getMax() > index1) {
                    this.insertCol(colsArray, index1 + 1L, colArray.getMax(), new CTCol[]{colArray});
                }
                colArray.setMin(index1);
                colArray.setMax(index1);
            }
            return colArray;
        }
        return null;
    }

    public CTCols addCleanColIntoCols(CTCols cols, CTCol col) {
        CTCols newCols = CTCols.Factory.newInstance();
        for (CTCol c : cols.getColList()) {
            this.cloneCol(newCols, c);
        }
        this.cloneCol(newCols, col);
        ColumnHelper.sortColumns(newCols);
        CTCol[] colArray = new CTCol[newCols.getColList().size()];
        newCols.getColList().toArray(colArray);
        CTCols returnCols = CTCols.Factory.newInstance();
        this.sweepCleanColumns(returnCols, colArray, col);
        colArray = new CTCol[returnCols.getColList().size()];
        returnCols.getColList().toArray(colArray);
        cols.setColArray(colArray);
        return returnCols;
    }

    private CTCol insertCol(CTCols cols, long min, long max, CTCol[] colsWithAttributes) {
        return this.insertCol(cols, min, max, colsWithAttributes, false, null);
    }

    private CTCol insertCol(CTCols cols, long min, long max, CTCol[] colsWithAttributes, boolean ignoreExistsCheck, CTCol overrideColumn) {
        if (ignoreExistsCheck || !this.columnExists(cols, min, max)) {
            CTCol newCol = cols.insertNewCol(0);
            newCol.setMin(min);
            newCol.setMax(max);
            for (CTCol col : colsWithAttributes) {
                this.setColumnAttributes(col, newCol);
            }
            if (overrideColumn != null) {
                this.setColumnAttributes(overrideColumn, newCol);
            }
            return newCol;
        }
        return null;
    }

    public boolean columnExists(CTCols cols, long index) {
        return this.columnExists1Based(cols, index + 1L);
    }

    private boolean columnExists1Based(CTCols cols, long index1) {
        for (int i = 0; i < cols.sizeOfColArray(); ++i) {
            if (cols.getColArray(i).getMin() != index1) continue;
            return true;
        }
        return false;
    }

    public void setColumnAttributes(CTCol fromCol, CTCol toCol) {
        if (fromCol.isSetBestFit()) {
            toCol.setBestFit(fromCol.getBestFit());
        }
        if (fromCol.isSetCustomWidth()) {
            toCol.setCustomWidth(fromCol.getCustomWidth());
        }
        if (fromCol.isSetHidden()) {
            toCol.setHidden(fromCol.getHidden());
        }
        if (fromCol.isSetStyle()) {
            toCol.setStyle(fromCol.getStyle());
        }
        if (fromCol.isSetWidth()) {
            toCol.setWidth(fromCol.getWidth());
        }
        if (fromCol.isSetCollapsed()) {
            toCol.setCollapsed(fromCol.getCollapsed());
        }
        if (fromCol.isSetPhonetic()) {
            toCol.setPhonetic(fromCol.getPhonetic());
        }
        if (fromCol.isSetOutlineLevel()) {
            toCol.setOutlineLevel(fromCol.getOutlineLevel());
        }
        toCol.setCollapsed(fromCol.isSetCollapsed());
    }

    public void setColBestFit(long index, boolean bestFit) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, false);
        col.setBestFit(bestFit);
    }

    public void setCustomWidth(long index, boolean bestFit) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, true);
        col.setCustomWidth(bestFit);
    }

    public void setColWidth(long index, double width) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, true);
        col.setWidth(width);
    }

    public void setColHidden(long index, boolean hidden) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, true);
        col.setHidden(hidden);
    }

    protected CTCol getOrCreateColumn1Based(long index1, boolean splitColumns) {
        CTCol col = this.getColumn1Based(index1, splitColumns);
        if (col == null) {
            col = this.worksheet.getColsArray(0).addNewCol();
            col.setMin(index1);
            col.setMax(index1);
        }
        return col;
    }

    public void setColDefaultStyle(long index, CellStyle style) {
        this.setColDefaultStyle(index, style.getIndex());
    }

    public void setColDefaultStyle(long index, int styleId) {
        CTCol col = this.getOrCreateColumn1Based(index + 1L, true);
        col.setStyle((long)styleId);
    }

    public int getColDefaultStyle(long index) {
        if (this.getColumn(index, false) != null) {
            return (int)this.getColumn(index, false).getStyle();
        }
        return -1;
    }

    private boolean columnExists(CTCols cols, long min, long max) {
        for (int i = 0; i < cols.sizeOfColArray(); ++i) {
            if (cols.getColArray(i).getMin() != min || cols.getColArray(i).getMax() != max) continue;
            return true;
        }
        return false;
    }

    public int getIndexOfColumn(CTCols cols, CTCol col) {
        for (int i = 0; i < cols.sizeOfColArray(); ++i) {
            if (cols.getColArray(i).getMin() != col.getMin() || cols.getColArray(i).getMax() != col.getMax()) continue;
            return i;
        }
        return -1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CTColByMaxComparator
    implements Comparator<CTCol> {
        private CTColByMaxComparator() {
        }

        @Override
        public int compare(CTCol arg0, CTCol arg1) {
            if (arg0.getMax() < arg1.getMax()) {
                return -1;
            }
            if (arg0.getMax() > arg1.getMax()) {
                return 1;
            }
            return 0;
        }
    }
}

