/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import java.io.IOException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.ChainingMode;
import org.apache.poi.poifs.crypt.CipherAlgorithm;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionHeader;
import org.apache.poi.poifs.crypt.EncryptionInfoBuilder;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.EncryptionVerifier;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.HashAlgorithm;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class EncryptionInfo {
    private final int versionMajor;
    private final int versionMinor;
    private final int encryptionFlags;
    private final EncryptionHeader header;
    private final EncryptionVerifier verifier;
    private final Decryptor decryptor;
    private final Encryptor encryptor;

    public EncryptionInfo(POIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public EncryptionInfo(NPOIFSFileSystem fs) throws IOException {
        this(fs.getRoot());
    }

    public EncryptionInfo(DirectoryNode dir) throws IOException {
        EncryptionInfoBuilder eib;
        DocumentInputStream dis = dir.createDocumentInputStream("EncryptionInfo");
        this.versionMajor = dis.readShort();
        this.versionMinor = dis.readShort();
        this.encryptionFlags = dis.readInt();
        EncryptionMode encryptionMode = this.versionMajor == EncryptionMode.agile.versionMajor && this.versionMinor == EncryptionMode.agile.versionMinor && this.encryptionFlags == EncryptionMode.agile.encryptionFlags ? EncryptionMode.agile : EncryptionMode.standard;
        try {
            eib = EncryptionInfo.getBuilder(encryptionMode);
        }
        catch (Exception e) {
            throw (IOException)new IOException().initCause(e);
        }
        eib.initialize(this, dis);
        this.header = eib.getHeader();
        this.verifier = eib.getVerifier();
        this.decryptor = eib.getDecryptor();
        this.encryptor = eib.getEncryptor();
    }

    public EncryptionInfo(POIFSFileSystem fs, EncryptionMode encryptionMode) throws IOException {
        this(fs.getRoot(), encryptionMode);
    }

    public EncryptionInfo(NPOIFSFileSystem fs, EncryptionMode encryptionMode) throws IOException {
        this(fs.getRoot(), encryptionMode);
    }

    public EncryptionInfo(DirectoryNode dir, EncryptionMode encryptionMode) throws EncryptedDocumentException {
        this(dir, encryptionMode, null, null, -1, -1, null);
    }

    public EncryptionInfo(POIFSFileSystem fs, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) throws EncryptedDocumentException {
        this(fs.getRoot(), encryptionMode, cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
    }

    public EncryptionInfo(NPOIFSFileSystem fs, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) throws EncryptedDocumentException {
        this(fs.getRoot(), encryptionMode, cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
    }

    public EncryptionInfo(DirectoryNode dir, EncryptionMode encryptionMode, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) throws EncryptedDocumentException {
        EncryptionInfoBuilder eib;
        this.versionMajor = encryptionMode.versionMajor;
        this.versionMinor = encryptionMode.versionMinor;
        this.encryptionFlags = encryptionMode.encryptionFlags;
        try {
            eib = EncryptionInfo.getBuilder(encryptionMode);
        }
        catch (Exception e) {
            throw new EncryptedDocumentException(e);
        }
        eib.initialize(this, cipherAlgorithm, hashAlgorithm, keyBits, blockSize, chainingMode);
        this.header = eib.getHeader();
        this.verifier = eib.getVerifier();
        this.decryptor = eib.getDecryptor();
        this.encryptor = eib.getEncryptor();
    }

    protected static EncryptionInfoBuilder getBuilder(EncryptionMode encryptionMode) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        EncryptionInfoBuilder eib = (EncryptionInfoBuilder)cl.loadClass(encryptionMode.builder).newInstance();
        return eib;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getEncryptionFlags() {
        return this.encryptionFlags;
    }

    public EncryptionHeader getHeader() {
        return this.header;
    }

    public EncryptionVerifier getVerifier() {
        return this.verifier;
    }

    public Decryptor getDecryptor() {
        return this.decryptor;
    }

    public Encryptor getEncryptor() {
        return this.encryptor;
    }
}

