/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.completion;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.drools.compiler.lang.dsl.DSLMapping;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.drools.eclipse.editors.completion.Node;

public class DSLTree {
    public static final String separator = "=";
    public static final String tab = "  ";
    private Node current = null;
    private Node last = null;
    private Node rootCond = null;
    private Node rootConseq = null;
    private boolean empty = true;
    private ArrayList<String> suggestions = new ArrayList();
    private HashMap<String, String> objToNL = new HashMap();

    public DSLTree() {
        this.rootCond = new Node("root");
        this.rootConseq = new Node("root");
    }

    public void buildTree(String dslFile) {
        this.buildTree(this.openDSLFile(dslFile));
    }

    public void buildTree(Reader dslcontents) {
        this.buildTree(this.createBufferedReader(dslcontents));
    }

    private void buildTree(BufferedReader breader) {
        this.rootCond.clearChildren();
        this.rootConseq.clearChildren();
        this.parseFile(breader);
        try {
            breader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.empty = false;
    }

    protected BufferedReader openDSLFile(String filename) {
        try {
            FileReader reader = new FileReader(filename);
            BufferedReader breader = new BufferedReader(reader);
            return breader;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected BufferedReader createBufferedReader(Reader reader) {
        return new BufferedReader(reader);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    protected void parseFile(BufferedReader reader) {
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                DSLMappingEntry.Section section = this.getSection(line);
                String nl = this.stripHeadingAndCode(line);
                String objname = this.getObjMetadata(nl);
                nl = this.stripObjMetadata(nl);
                this.addEntry(section, nl, objname);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void buildTree(DSLMapping mapping) {
        for (DSLMappingEntry entry : mapping.getEntries()) {
            DSLMappingEntry.Section section = entry.getSection();
            String nl = entry.getMappingKey();
            String objname = entry.getMetaData().getMetaData();
            this.addEntry(section, nl, objname);
        }
    }

    private void addEntry(DSLMappingEntry.Section section, String nl, String objname) {
        if (!nl.startsWith("-")) {
            if (objname != null && !"".equals(objname)) {
                this.addObjToNLMap(objname, nl);
            }
            String[] tokenz = nl.split("\\s");
            if (section == DSLMappingEntry.CONDITION || section == DSLMappingEntry.ANY) {
                this.addTokens(tokenz, this.rootCond);
            }
            if (section == DSLMappingEntry.CONSEQUENCE || section == DSLMappingEntry.ANY) {
                this.addTokens(tokenz, this.rootConseq);
            }
        } else {
            String res = this.objToNL.get(objname);
            StringTokenizer tokenz = new StringTokenizer(nl);
            this.addTokens(res, tokenz);
        }
    }

    public void addObjToNLMap(String objname, String nl) {
        if (!objname.startsWith("-")) {
            this.objToNL.put(objname, nl);
        }
    }

    protected DSLMappingEntry.Section getSection(String text) {
        if (text.startsWith(DSLMappingEntry.CONDITION.getSymbol())) {
            return DSLMappingEntry.CONDITION;
        }
        if (text.startsWith(DSLMappingEntry.CONSEQUENCE.getSymbol())) {
            return DSLMappingEntry.CONSEQUENCE;
        }
        if (text.startsWith(DSLMappingEntry.ANY.getSymbol())) {
            return DSLMappingEntry.ANY;
        }
        if (text.startsWith(DSLMappingEntry.KEYWORD.getSymbol())) {
            return DSLMappingEntry.KEYWORD;
        }
        return null;
    }

    protected String stripHeadingAndCode(String text) {
        if (text.startsWith(DSLMappingEntry.CONDITION.getSymbol())) {
            return text.substring(DSLMappingEntry.CONDITION.getSymbol().length() + 2, text.indexOf(separator));
        }
        if (text.startsWith(DSLMappingEntry.CONSEQUENCE.getSymbol())) {
            return text.substring(DSLMappingEntry.CONSEQUENCE.getSymbol().length() + 2, text.indexOf(separator));
        }
        if (text.startsWith(DSLMappingEntry.ANY.getSymbol())) {
            return text.substring(DSLMappingEntry.ANY.getSymbol().length() + 2, text.indexOf(separator));
        }
        if (text.startsWith("#")) {
            return "";
        }
        return text;
    }

    protected String getObjMetadata(String text) {
        if (text.startsWith("[")) {
            return text.substring(1, text.lastIndexOf("]"));
        }
        return "";
    }

    protected String stripObjMetadata(String text) {
        if (text.startsWith("[")) {
            return text.substring(text.lastIndexOf("]") + 1);
        }
        return text;
    }

    public void addTokens(String metadata, StringTokenizer tokens) {
        Node mnode;
        Node thenode = mnode = this.rootCond.addToken(metadata);
        while (tokens.hasMoreTokens()) {
            Node newnode;
            thenode = newnode = thenode.addToken(tokens.nextToken());
        }
    }

    public void addTokens(String[] tokens, Node rootNode) {
        Node thenode = rootNode;
        int i = 0;
        while (i < tokens.length) {
            Node newnode;
            thenode = newnode = thenode.addToken(tokens[i]);
            ++i;
        }
    }

    public Node[] getConditionChildren(String text) {
        Node thenode = this.rootCond;
        if (text.length() > 0) {
            StringTokenizer tokenz = new StringTokenizer(text);
            this.last = this.current;
            while (tokenz.hasMoreTokens()) {
                String strtk = tokenz.nextToken();
                Node ch = thenode.getChild(strtk);
                if (ch == null) break;
                thenode = ch;
            }
            if (thenode != this.rootCond) {
                this.current = thenode;
            }
        }
        Collection<Node> children = thenode.getChildren();
        Node[] nchild = new Node[children.size()];
        return children.toArray(nchild);
    }

    public Node[] getConsequenceChildren(String text) {
        Node thenode = this.rootConseq;
        if (text.length() >= 0) {
            StringTokenizer tokenz = new StringTokenizer(text);
            this.last = this.current;
            while (tokenz.hasMoreTokens()) {
                String strtk = tokenz.nextToken();
                Node ch = thenode.getChild(strtk);
                if (ch == null) break;
                thenode = ch;
            }
            if (thenode != this.rootConseq) {
                this.current = thenode;
            }
        }
        Collection<Node> children = thenode.getChildren();
        Node[] nchild = new Node[children.size()];
        return children.toArray(nchild);
    }

    public Node[] getChildren(String obj, String text) {
        Node thenode = this.rootCond.getChild(obj);
        if (thenode == null) {
            for (Node child : this.rootCond.getChildren()) {
                int index;
                String tokenText = child.getToken();
                if (tokenText == null || (index = tokenText.indexOf("{")) == -1) continue;
                String substring = tokenText.substring(0, index);
                if (obj == null || !obj.startsWith(substring)) continue;
                thenode = child;
            }
        }
        if (thenode != null && text.length() > 0) {
            StringTokenizer tokenz = new StringTokenizer(text);
            this.last = this.current;
            while (tokenz.hasMoreTokens()) {
                String strtk = tokenz.nextToken();
                Node ch = thenode.getChild(strtk);
                if (ch == null) break;
                thenode = ch;
            }
            if (thenode != this.rootCond) {
                this.current = thenode;
            }
        }
        if (thenode == null) {
            return null;
        }
        Collection<Node> children = thenode.getChildren();
        Node[] nchild = new Node[children.size()];
        return children.toArray(nchild);
    }

    public ArrayList<String> getConditionChildrenList(String text, boolean addChildren) {
        Node[] c = this.getConditionChildren(text);
        this.suggestions.clear();
        int idx = 0;
        while (idx < c.length) {
            this.suggestions.add(c[idx].getToken());
            if (addChildren) {
                this.addChildToList(c[idx], c[idx].getToken(), this.suggestions);
            }
            ++idx;
        }
        return this.suggestions;
    }

    public ArrayList<String> getConsequenceChildrenList(String text, boolean addChildren) {
        Node[] c = this.getConsequenceChildren(text);
        this.suggestions.clear();
        int idx = 0;
        while (idx < c.length) {
            if (addChildren) {
                this.addChildToList(c[idx], c[idx].getToken(), this.suggestions);
            } else {
                this.suggestions.add(c[idx].getToken());
            }
            ++idx;
        }
        return this.suggestions;
    }

    public ArrayList<String> getChildrenList(String obj, String text, boolean addChildren, boolean firstLine) {
        Node[] c = this.getChildren(obj, text);
        this.suggestions.clear();
        if (c != null) {
            int idx = 0;
            while (idx < c.length) {
                if (addChildren) {
                    this.addChildToList(c[idx], c[idx].getToken(), this.suggestions);
                } else {
                    this.suggestions.add(c[idx].getToken());
                }
                ++idx;
            }
        }
        if (text.trim().length() == 0 || this.suggestions.isEmpty()) {
            for (Node t : this.rootCond.getChildren()) {
                if (firstLine && t.getToken() == null || this.suggestions.contains(t.getToken())) continue;
                if (addChildren) {
                    this.addChildToList(t, t.getToken(), this.suggestions);
                    continue;
                }
                this.suggestions.add(t.getToken());
            }
        }
        return this.suggestions;
    }

    public void addChildToList(Node n, String prefix, ArrayList<String> list) {
        if (n.getChildren().size() > 0) {
            for (Node child : n.getChildren()) {
                if (prefix != null && "-".equals(child.getToken())) {
                    if (!list.contains(prefix)) {
                        list.add(prefix);
                    }
                    return;
                }
                String text = String.valueOf(prefix == null ? "" : String.valueOf(prefix) + " ") + child.getToken();
                this.addChildToList(child, text, list);
            }
        } else if (!list.contains(prefix)) {
            list.add(prefix);
        }
    }

    public Node getCurrent() {
        return this.current;
    }

    public void setCurrent(Node current) {
        this.current = current;
    }

    public Node getLast() {
        return this.last;
    }

    public void setLast(Node last) {
        this.last = last;
    }

    public void printTree() {
        System.out.println("ROOT");
        for (Node n : this.rootCond.getChildren()) {
            this.printNode(n);
        }
    }

    protected void printNode(Node n) {
        this.printTabs(n.getDepth());
        System.out.println("- \"" + n.getToken() + "\"");
        for (Node c : n.getChildren()) {
            this.printNode(c);
        }
    }

    protected void printTabs(int count) {
        int idx = 0;
        while (idx < count) {
            System.out.print(tab);
            ++idx;
        }
    }
}

