/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete;

import java.util.ArrayList;
import java.util.Iterator;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.builder.DroolsBuilder;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.rete.ReteooLayoutFactory;
import org.drools.eclipse.editors.rete.RowList;
import org.drools.eclipse.editors.rete.model.ReteGraph;
import org.drools.eclipse.editors.rete.part.VertexEditPartFactory;
import org.drools.eclipse.reteoo.BaseVertex;
import org.drools.eclipse.reteoo.ReteooVisitor;
import org.drools.eclipse.util.ProjectClassLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IEditorPart;
import org.kie.api.KieBaseConfiguration;
import org.kie.internal.KnowledgeBaseFactory;

public class ReteViewer
extends GraphicalEditor {
    public static final String MSG_PARSE_ERROR = "Unable to parse rules to show RETE view!";
    private static final int SIMPLE_ROUTER_MIN_NODES = 100;
    ScalableFreeformRootEditPart rootEditPart = new ScalableFreeformRootEditPart();
    private ReteGraph diagram = new ReteGraph();
    private boolean relayoutRequired = true;
    private DRLRuleEditor drlEditor;

    public ReteViewer(DRLRuleEditor drlEditor) {
        this.drlEditor = drlEditor;
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.getControl().setBackground(ColorConstants.white);
        viewer.setEditPartFactory((EditPartFactory)new VertexEditPartFactory());
        viewer.setRootEditPart((RootEditPart)this.rootEditPart);
        viewer.setKeyHandler((KeyHandler)new GraphicalViewerKeyHandler(viewer));
    }

    public Object getAdapter(Class type) {
        if (type == ZoomManager.class) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return super.getAdapter(type);
    }

    public ReteGraph loadReteModel(IProgressMonitor monitor, String contents) throws Throwable {
        if (!this.relayoutRequired) {
            return this.diagram;
        }
        ReteGraph newDiagram = new ReteGraph();
        try {
            monitor.beginTask("Loading RETE Tree", 100);
            monitor.subTask("Loading Rule Base");
            InternalKnowledgeBase ruleBase = null;
            try {
                DRLInfo drlInfo;
                IResource resource = this.drlEditor.getResource();
                ClassLoader newLoader = DroolsBuilder.class.getClassLoader();
                if (resource.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                    IJavaProject project = JavaCore.create((IProject)resource.getProject());
                    newLoader = ProjectClassLoader.getProjectClassLoader(project);
                }
                if ((drlInfo = DroolsEclipsePlugin.getDefault().parseResource(this.drlEditor, true, true)) == null) {
                    throw new Exception("Could not find DRL info");
                }
                if (drlInfo.getBuilderErrors().length > 0) {
                    throw new Exception(String.valueOf(drlInfo.getBuilderErrors().length) + " build errors");
                }
                if (drlInfo.getParserErrors().size() > 0) {
                    throw new Exception(String.valueOf(drlInfo.getParserErrors().size()) + " parser errors");
                }
                InternalKnowledgePackage pkg = drlInfo.getPackage();
                RuleBaseConfiguration config = new RuleBaseConfiguration();
                config.setClassLoader(newLoader);
                ruleBase = (InternalKnowledgeBase)KnowledgeBaseFactory.newKnowledgeBase((KieBaseConfiguration)config);
                if (pkg != null) {
                    ruleBase.addPackage(pkg);
                }
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
                throw new Exception("Unable to parse rules to show RETE view! " + t.getMessage());
            }
            monitor.worked(50);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.subTask("Building RETE Tree");
            ReteooVisitor visitor = new ReteooVisitor(newDiagram);
            visitor.visitInternalKnowledgeBase(ruleBase);
            monitor.worked(30);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.subTask("Calculating RETE Tree Layout");
            BaseVertex rootVertex = visitor.getRootVertex();
            RowList rowList = ReteooLayoutFactory.calculateReteRows(rootVertex);
            ReteooLayoutFactory.layoutRowList(newDiagram, rowList);
            this.zeroBaseDiagram(newDiagram);
            monitor.worked(20);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.done();
        }
        catch (Throwable t) {
            if (!(t instanceof InterruptedException)) {
                DroolsEclipsePlugin.log(t);
            }
            throw t;
        }
        this.relayoutRequired = false;
        return newDiagram;
    }

    private ReteGraph getModel() {
        return this.diagram;
    }

    protected void initializeGraphicalViewer() {
        ZoomManager zoomManager = this.rootEditPart.getZoomManager();
        ArrayList<String> zoomLevels = new ArrayList<String>(3);
        zoomLevels.add(ZoomManager.FIT_ALL);
        zoomLevels.add(ZoomManager.FIT_HEIGHT);
        zoomLevels.add(ZoomManager.FIT_WIDTH);
        zoomManager.setZoomLevelContributions(zoomLevels);
        this.getGraphicalViewer().setProperty(MouseWheelHandler.KeyGenerator.getKey((int)SWT.MOD1), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    private void zeroBaseDiagram(ReteGraph graph) {
        Dimension dim = this.rootEditPart.getContentPane().getSize();
        int minx = 0;
        int miny = 0;
        int maxx = 0;
        int x = dim.width;
        Iterator<BaseVertex> nodeIter = graph.getChildren().iterator();
        while (nodeIter.hasNext()) {
            Point loc = nodeIter.next().getLocation();
            minx = Math.min(loc.x, minx);
            maxx = Math.max(loc.x, maxx);
            miny = Math.min(loc.y, miny);
        }
        int delta = (x - (maxx - minx + 20)) / 2;
        minx -= delta;
        for (BaseVertex vertex : graph.getChildren()) {
            Point loc = vertex.getLocation();
            vertex.setLocation(new Point(loc.x - minx, loc.y - miny));
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean isDirty() {
        return false;
    }

    public void fireDocumentChanged() {
        this.relayoutRequired = true;
    }

    public void drawGraph(ReteGraph newGraph) {
        boolean isNewDiagram;
        LayerManager manager = (LayerManager)this.getGraphicalViewer().getEditPartRegistry().get(LayerManager.ID);
        ConnectionLayer connLayer = (ConnectionLayer)manager.getLayer((Object)"Connection Layer");
        if (this.getGraphicalViewer().getContents() == null) {
            this.getGraphicalViewer().setContents((Object)this.getModel());
        }
        boolean bl = isNewDiagram = newGraph != null && newGraph != this.diagram;
        if (isNewDiagram) {
            this.diagram.removeAll();
        }
        Object router = isNewDiagram && newGraph.getChildren().size() < 100 || !isNewDiagram && this.getModel().getChildren().size() < 100 ? new ShortestPathConnectionRouter((IFigure)this.rootEditPart.getContentPane().getChildren().get(0)) : ConnectionRouter.NULL;
        connLayer.setConnectionRouter(router);
        if (newGraph != null && newGraph != this.diagram) {
            this.diagram.addAll(newGraph.getChildren());
        }
    }
}

