/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.view.property;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.eclipse.flow.common.view.property.EditBeanDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class EditListDialog<T>
extends EditBeanDialog<List<T>> {
    private Class<? extends EditBeanDialog<T>> editItemDialogClass;
    private List<T> newList;
    private ListViewer listViewer;
    private Button removeButton;
    private Button editButton;

    protected EditListDialog(Shell parentShell, String title, Class<? extends EditBeanDialog<T>> editItemDialogClass) {
        super(parentShell, title);
        this.editItemDialogClass = editItemDialogClass;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.listViewer = new ListViewer(composite, 4);
        this.listViewer.add(this.newList.toArray());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditListDialog.this.removeButton.setEnabled(!event.getSelection().isEmpty());
                EditListDialog.this.editButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        this.listViewer.getList().setLayoutData((Object)gridData);
        Button addButton = new Button(composite, 0);
        addButton.setText("Add");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditListDialog.this.addItem();
            }
        });
        this.removeButton = new Button(composite, 0);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditListDialog.this.removeItem();
            }
        });
        this.editButton = new Button(composite, 0);
        this.editButton.setText("Edit");
        this.editButton.setEnabled(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditListDialog.this.editItem();
            }
        });
        return composite;
    }

    @Override
    public void setValue(List<T> value) {
        super.setValue(value);
        this.newList = value == null ? new ArrayList<T>() : new ArrayList<T>(value);
    }

    @Override
    protected List<T> updateValue(List<T> value) {
        return this.newList;
    }

    private void addItem() {
        EditBeanDialog<T> dialog = this.createEditItemDialog();
        dialog.setValue(this.createItem());
        int code = dialog.open();
        T result = dialog.getValue();
        if (code != 1) {
            this.newList.add(result);
            this.listViewer.add(result);
        }
    }

    protected abstract T createItem();

    private void editItem() {
        EditBeanDialog<T> dialog = this.createEditItemDialog();
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object value = iterator.next();
            int index = this.newList.lastIndexOf(value);
            dialog.setValue(value);
            int code = dialog.open();
            if (code != 1) {
                T result = dialog.getValue();
                this.newList.set(index, result);
                this.listViewer.remove(value);
                this.listViewer.add(result);
            }
        }
    }

    private void removeItem() {
        Iterator iterator = ((StructuredSelection)this.listViewer.getSelection()).iterator();
        if (iterator.hasNext()) {
            Object item = iterator.next();
            this.newList.remove(item);
            this.listViewer.remove(item);
        }
    }

    protected EditBeanDialog<T> createEditItemDialog() {
        try {
            return this.editItemDialogClass.getConstructor(Shell.class).newInstance(this.getShell());
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

