/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.view.property.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.eclipse.editors.AbstractRuleEditor;
import org.drools.eclipse.editors.DRLRuleEditor;
import org.drools.eclipse.editors.completion.RuleCompletionProcessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jbpm.workflow.core.WorkflowProcess;

public class ActionCompletionProcessor
extends RuleCompletionProcessor {
    private WorkflowProcess process;
    private List<String> imports;
    private List<String> functions;
    private List<GlobalDescr> globals;
    private Map<String, String> attributes;
    private String dialect;

    public ActionCompletionProcessor(WorkflowProcess process) {
        super((AbstractRuleEditor)null);
        this.process = process;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
        this.attributes = null;
    }

    @Override
    public IEditorPart getEditor() {
        IWorkbenchPage workbenchPage;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (workbenchPage = workbenchWindow.getActivePage()) != null) {
            return workbenchPage.getActiveEditor();
        }
        return null;
    }

    @Override
    protected String readBackwards(int documentOffset, IDocument doc) throws BadLocationException {
        int startPart = doc.getPartition(documentOffset).getOffset();
        String prefix = doc.get(startPart, documentOffset - startPart);
        return "rule dummy " + (this.dialect == null ? "" : " dialect \"" + this.dialect + "\" ") + "\n when \n then \n org.kie.api.runtime.process.ProcessContext context = null; \n org.kie.api.runtime.process.ProcessContext kcontext = null; \n " + prefix;
    }

    @Override
    public List<String> getImports() {
        if (this.imports == null) {
            this.loadImports();
        }
        return this.imports;
    }

    private void loadImports() {
        this.imports = new ArrayList<String>();
        List imports = this.process.getImports();
        if (imports != null) {
            for (String importName : imports) {
                if (importName.endsWith(".*")) {
                    IJavaProject javaProject = this.getJavaProject();
                    if (javaProject == null) continue;
                    String packageName = importName.substring(0, importName.length() - 2);
                    this.imports.addAll(DRLRuleEditor.getAllClassesInPackage(packageName, javaProject));
                    continue;
                }
                this.imports.add(importName);
            }
        }
    }

    @Override
    public List<GlobalDescr> getGlobals() {
        if (this.globals == null) {
            this.loadGlobals();
        }
        return this.globals;
    }

    private void loadGlobals() {
        String[] globalNames = this.process.getGlobalNames();
        if (this.globals == null) {
            this.globals = new ArrayList<GlobalDescr>(globalNames.length);
        }
        String[] stringArray = globalNames;
        int n = globalNames.length;
        int n2 = 0;
        while (n2 < n) {
            String globalName = stringArray[n2];
            this.globals.add(new GlobalDescr(globalName, "java.lang.Object"));
            ++n2;
        }
    }

    @Override
    protected List<String> getFunctions() {
        if (this.functions == null) {
            this.loadFunctions();
        }
        return this.functions;
    }

    private void loadFunctions() {
        this.functions = new ArrayList<String>();
        List imports = this.process.getFunctionImports();
        if (imports != null) {
            for (String functionImport : imports) {
                int index = functionImport.lastIndexOf(46);
                if (index == -1) continue;
                this.functions.add(functionImport.substring(index + 1));
            }
        }
    }

    private void loadAttributes() {
        this.attributes = new HashMap<String, String>();
        if (this.dialect != null) {
            this.attributes.put("dialect", this.dialect);
        }
    }

    @Override
    protected Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.loadAttributes();
        }
        return this.attributes;
    }

    private IJavaProject getJavaProject() {
        IEditorPart editor = this.getEditor();
        if (editor != null && editor.getEditorInput() instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
            try {
                if (file.getProject().getNature("org.eclipse.jdt.core.javanature") != null) {
                    return JavaCore.create((IProject)file.getProject());
                }
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    public void reset() {
        this.imports = null;
        this.globals = null;
    }
}

