/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.compiler.compiler.xml.XmlDumper;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.event.EventTransformer;
import org.jbpm.process.core.event.EventTransformerImpl;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.event.NonAcceptingEventTypeFilter;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.runtime.process.DataTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BoundaryEventHandler
extends AbstractNodeHandler {
    private DataTransformerRegistry transformerRegistry = DataTransformerRegistry.get();

    @Override
    protected Node createNode(Attributes attrs) {
        return new BoundaryEventNode();
    }

    public Class generateNodeFor() {
        return BoundaryEventNode.class;
    }

    @Override
    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Node node = (Node)parser.getCurrent();
        String attachedTo = element.getAttribute("attachedToRef");
        Attr cancelActivityAttr = element.getAttributeNode("cancelActivity");
        boolean cancelActivity = Boolean.parseBoolean(cancelActivityAttr.getValue());
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("escalationEventDefinition".equals(nodeName)) {
                this.handleEscalationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                this.handleErrorNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                this.handleTimerNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("compensateEventDefinition".equals(nodeName)) {
                this.handleCompensationNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                this.handleSignalNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if ("conditionalEventDefinition".equals(nodeName)) {
                this.handleConditionNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
                break;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            this.handleMessageNode(node, element, uri, localName, parser, attachedTo, cancelActivity);
            break;
        }
        org.jbpm.workflow.core.NodeContainer nodeContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((org.kie.api.definition.process.Node)node);
        return node;
    }

    protected void handleEscalationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode);
                continue;
            }
            if (!"escalationEventDefinition".equals(nodeName)) continue;
            String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
            if (escalationRef != null && escalationRef.trim().length() > 0) {
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new IllegalArgumentException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new IllegalArgumentException("Could not find escalation " + escalationRef);
                }
                ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
                EventTypeFilter eventFilter = new EventTypeFilter();
                String type = escalation.getEscalationCode();
                eventFilter.setType("Escalation-" + attachedTo + "-" + type);
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
                eventNode.setMetaData("EscalationEvent", (Object)type);
                continue;
            }
            throw new UnsupportedOperationException("General escalation is not yet supported.");
        }
    }

    protected void handleErrorNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String errorRef;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode);
                continue;
            }
            if (!"errorEventDefinition".equals(nodeName) || (errorRef = ((Element)xmlNode).getAttribute("errorRef")) == null || errorRef.trim().length() <= 0) continue;
            List errors = (List)((ProcessBuildData)parser.getData()).getMetaData("Errors");
            if (errors == null) {
                throw new IllegalArgumentException("No errors found");
            }
            Error error = null;
            for (Error listError : errors) {
                if (!errorRef.equals(listError.getId())) continue;
                error = listError;
            }
            if (error == null) {
                throw new IllegalArgumentException("Could not find error " + errorRef);
            }
            String type = error.getErrorCode();
            if (type == null) {
                type = error.getId();
            }
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Error-" + attachedTo + "-" + type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("ErrorEvent", (Object)type);
            eventNode.setMetaData("ErrorStructureRef", (Object)error.getStructureRef());
        }
    }

    protected void handleTimerNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            EventTypeFilter eventFilter;
            ArrayList<EventTypeFilter> eventFilters;
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            String timeDuration = null;
            String timeCycle = null;
            String timeDate = null;
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String subNodeName = subNode.getNodeName();
                if ("timeDuration".equals(subNodeName)) {
                    timeDuration = subNode.getTextContent();
                    break;
                }
                if ("timeCycle".equals(subNodeName)) {
                    timeCycle = subNode.getTextContent();
                    break;
                }
                if ("timeDate".equals(subNodeName)) {
                    timeDate = subNode.getTextContent();
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            if (timeDuration != null && timeDuration.trim().length() > 0) {
                eventFilters = new ArrayList<EventTypeFilter>();
                eventFilter = new EventTypeFilter();
                eventFilter.setType("Timer-" + attachedTo + "-" + timeDuration);
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
                eventNode.setMetaData("TimeDuration", (Object)timeDuration);
                continue;
            }
            if (timeCycle != null && timeCycle.trim().length() > 0) {
                eventFilters = new ArrayList();
                eventFilter = new EventTypeFilter();
                eventFilter.setType("Timer-" + attachedTo + "-" + timeCycle);
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
                eventNode.setMetaData("TimeCycle", (Object)timeCycle);
                continue;
            }
            if (timeDate == null || timeDate.trim().length() <= 0) continue;
            eventFilters = new ArrayList();
            eventFilter = new EventTypeFilter();
            eventFilter.setType("Timer-" + attachedTo + "-" + timeDate);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setMetaData("TimeDate", (Object)timeDate);
        }
    }

    protected void handleCompensationNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        BoundaryEventNode eventNode = (BoundaryEventNode)parser.getCurrent();
        super.handleNode(node, element, uri, localName, parser);
        NodeList childs = element.getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            String activityRef;
            Element el;
            if (!(childs.item(i) instanceof Element) || !"compensateEventDefinition".equalsIgnoreCase((el = (Element)childs.item(i)).getNodeName()) || (activityRef = el.getAttribute("activityRef")) == null || activityRef.length() <= 0) continue;
            logger.warn("activityRef value [" + activityRef + "] on Boundary Event '" + eventNode.getMetaData("UniqueId") + "' ignored per the BPMN2 specification.");
        }
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setAttachedToNodeId(attachedTo);
        org.jbpm.workflow.core.NodeContainer parentContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
        NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
        eventFilter.setType("Compensation");
        ArrayList<NonAcceptingEventTypeFilter> eventFilters = new ArrayList<NonAcceptingEventTypeFilter>();
        eventNode.setEventFilters(eventFilters);
        eventFilters.add(eventFilter);
        ProcessHandler.addCompensationScope((RuleFlowProcess)parser.getParent(RuleFlowProcess.class), (org.kie.api.definition.process.Node)eventNode, (NodeContainer)parentContainer, attachedTo);
    }

    protected void handleSignalNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String type;
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode);
                continue;
            }
            if (!"signalEventDefinition".equals(nodeName) || (type = ((Element)xmlNode).getAttribute("signalRef")) == null || type.trim().length() <= 0) continue;
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType(type);
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
            eventNode.setScope("external");
            eventNode.setMetaData("SignalName", (Object)type);
        }
    }

    protected void handleConditionNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        block0: for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode);
                continue;
            }
            if (!"conditionalEventDefinition".equals(nodeName)) continue;
            for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                String subnodeName = subNode.getNodeName();
                if (!"condition".equals(subnodeName)) continue;
                eventNode.setMetaData("Condition", (Object)xmlNode.getTextContent());
                ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
                EventTypeFilter eventFilter = new EventTypeFilter();
                eventFilter.setType("Condition-" + attachedTo);
                eventFilters.add(eventFilter);
                eventNode.setScope("external");
                eventNode.setEventFilters(eventFilters);
                continue block0;
            }
        }
    }

    protected void handleMessageNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser, String attachedTo, boolean cancelActivity) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        BoundaryEventNode eventNode = (BoundaryEventNode)node;
        eventNode.setMetaData("AttachedTo", (Object)attachedTo);
        eventNode.setMetaData("CancelActivity", (Object)cancelActivity);
        eventNode.setAttachedToNodeId(attachedTo);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("dataOutput".equals(nodeName)) {
                String id = ((Element)xmlNode).getAttribute("id");
                String outputName = ((Element)xmlNode).getAttribute("name");
                this.dataOutputs.put(id, outputName);
                continue;
            }
            if ("dataOutputAssociation".equals(nodeName)) {
                this.readDataOutputAssociation(xmlNode, (EventNode)eventNode);
                continue;
            }
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new IllegalArgumentException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new IllegalArgumentException("Could not find message " + messageRef);
            }
            eventNode.setMetaData("MessageType", (Object)message.getType());
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Message-" + messageRef);
            eventFilters.add(eventFilter);
            eventNode.setScope("external");
            eventNode.setEventFilters(eventFilters);
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, EventNode eventNode) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        String from = subNode.getTextContent();
        subNode = subNode.getNextSibling();
        String to = subNode.getTextContent();
        Transformation transformation = null;
        if ((subNode = subNode.getNextSibling()) != null && "transformation".equals(subNode.getNodeName())) {
            String lang = subNode.getAttributes().getNamedItem("language").getNodeValue();
            String expression = subNode.getTextContent();
            DataTransformer transformer = this.transformerRegistry.find(lang);
            if (transformer == null) {
                throw new IllegalArgumentException("No transformer registered for language " + lang);
            }
            transformation = new Transformation(lang, expression, (String)this.dataOutputs.get(from));
            eventNode.setMetaData("Transformation", (Object)transformation);
            eventNode.setEventTransformer((EventTransformer)new EventTransformerImpl(transformation));
        }
        eventNode.setVariableName(to);
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        EventNode eventNode = (EventNode)node;
        String attachedTo = (String)eventNode.getMetaData("AttachedTo");
        if (attachedTo != null) {
            String type = ((EventTypeFilter)eventNode.getEventFilters().get(0)).getType();
            if (type.startsWith("Escalation-")) {
                type = type.substring(attachedTo.length() + 12);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <escalationEventDefinition escalationRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" />" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Error-")) {
                type = type.substring(attachedTo.length() + 7);
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                String errorId = this.getErrorIdForErrorCode(type, (Node)eventNode);
                xmlDump.append("      <errorEventDefinition errorRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(errorId) + "\" />" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Timer-")) {
                type = type.substring(attachedTo.length() + 7);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                String duration = (String)eventNode.getMetaData("TimeDuration");
                String cycle = (String)eventNode.getMetaData("TimeCycle");
                if (duration != null && cycle != null) {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)duration) + "</timeDuration>" + EOL + "        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)cycle) + "</timeCycle>" + EOL + "      </timerEventDefinition>" + EOL);
                } else if (duration != null) {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)duration) + "</timeDuration>" + EOL + "      </timerEventDefinition>" + EOL);
                } else {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)cycle) + "</timeCycle>" + EOL + "      </timerEventDefinition>" + EOL);
                }
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.equals("Compensation")) {
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <compensateEventDefinition/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (node.getMetaData().get("SignalName") != null) {
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\"/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (node.getMetaData().get("Condition") != null) {
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <conditionalEventDefinition>" + EOL);
                xmlDump.append("        <condition xsi:type=\"tFormalExpression\" language=\"http://www.jboss.org/drools/rule\">" + eventNode.getMetaData("Condition") + "</condition>" + EOL);
                xmlDump.append("      </conditionalEventDefinition>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Message-")) {
                type = type.substring(8);
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                this.writeExtensionElements(node, xmlDump);
                xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            }
        }
    }
}

