/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence;

import java.util.Set;
import java.util.TreeSet;
import org.drools.persistence.TransactionSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionSynchronizationContainer
implements TransactionSynchronization {
    private static Logger logger = LoggerFactory.getLogger(TransactionSynchronizationContainer.class);
    public static final String RESOURCE_KEY = "org.drools.persistence.txsync.container";
    private Set<TransactionSynchronization> synchronizations = new TreeSet<TransactionSynchronization>();

    @Override
    public void beforeCompletion() {
        TransactionSynchronization[] txSyncArray;
        for (TransactionSynchronization txSync : txSyncArray = this.synchronizations.toArray(new TransactionSynchronization[this.synchronizations.size()])) {
            txSync.beforeCompletion();
        }
    }

    @Override
    public void afterCompletion(int status) {
        TransactionSynchronization[] txSyncArray;
        for (TransactionSynchronization txSync : txSyncArray = this.synchronizations.toArray(new TransactionSynchronization[this.synchronizations.size()])) {
            txSync.afterCompletion(status);
        }
    }

    public void addTransactionSynchronization(TransactionSynchronization txSync) {
        this.synchronizations.add(txSync);
        logger.debug("Adding sync {} total syncs ", (Object)txSync, (Object)this.synchronizations.size());
    }
}

