/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.LeftTupleSets;
import org.drools.core.phreak.RuleNetworkEvaluator;
import org.drools.core.reteoo.EvalConditionNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.rule.EvalCondition;

public class PhreakEvalNode {
    private static final String EVAL_LEFT_TUPLE_DELETED = "EVAL_LEFT_TUPLE_DELETED";

    public void doNode(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        if (srcLeftTuples.getDeleteFirst() != null) {
            this.doLeftDeletes(srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getUpdateFirst() != null) {
            this.doLeftUpdates(evalNode, em, sink, wm, srcLeftTuples, trgLeftTuples, stagedLeftTuples);
        }
        if (srcLeftTuples.getInsertFirst() != null) {
            this.doLeftInserts(evalNode, em, sink, wm, srcLeftTuples, trgLeftTuples);
        }
        srcLeftTuples.resetAll();
    }

    public void doLeftInserts(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples) {
        EvalCondition condition = evalNode.getCondition();
        LeftTuple leftTuple = srcLeftTuples.getInsertFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            boolean allowed = condition.isAllowed(leftTuple, wm, em.context);
            if (allowed) {
                boolean useLeftMemory = RuleNetworkEvaluator.useLeftMemory(evalNode, leftTuple);
                trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), useLeftMemory));
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftUpdates(EvalConditionNode evalNode, EvalConditionNode.EvalMemory em, LeftTupleSink sink, InternalWorkingMemory wm, LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        EvalCondition condition = evalNode.getCondition();
        LeftTuple leftTuple = srcLeftTuples.getUpdateFirst();
        while (leftTuple != null) {
            LeftTuple childLeftTuple;
            LeftTuple next = leftTuple.getStagedNext();
            boolean wasPropagated = leftTuple.getFirstChild() != null && leftTuple.getObject() != EVAL_LEFT_TUPLE_DELETED;
            boolean allowed = condition.isAllowed(leftTuple, wm, em.context);
            if (allowed) {
                leftTuple.setObject(null);
                if (wasPropagated) {
                    childLeftTuple = leftTuple.getFirstChild();
                    childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                    switch (childLeftTuple.getStagedType()) {
                        case 1: {
                            stagedLeftTuples.removeInsert(childLeftTuple);
                            break;
                        }
                        case 2: {
                            stagedLeftTuples.removeUpdate(childLeftTuple);
                        }
                    }
                    trgLeftTuples.addUpdate(childLeftTuple);
                } else {
                    trgLeftTuples.addInsert(sink.createLeftTuple(leftTuple, sink, leftTuple.getPropagationContext(), true));
                }
            } else if (wasPropagated) {
                leftTuple.setObject(EVAL_LEFT_TUPLE_DELETED);
                childLeftTuple = leftTuple.getFirstChild();
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                switch (childLeftTuple.getStagedType()) {
                    case 1: {
                        stagedLeftTuples.removeInsert(childLeftTuple);
                        break;
                    }
                    case 2: {
                        stagedLeftTuples.removeUpdate(childLeftTuple);
                    }
                }
                trgLeftTuples.addDelete(childLeftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }

    public void doLeftDeletes(LeftTupleSets srcLeftTuples, LeftTupleSets trgLeftTuples, LeftTupleSets stagedLeftTuples) {
        LeftTuple leftTuple = srcLeftTuples.getDeleteFirst();
        while (leftTuple != null) {
            LeftTuple next = leftTuple.getStagedNext();
            LeftTuple childLeftTuple = leftTuple.getFirstChild();
            if (childLeftTuple != null) {
                switch (childLeftTuple.getStagedType()) {
                    case 1: {
                        stagedLeftTuples.removeInsert(childLeftTuple);
                        break;
                    }
                    case 2: {
                        stagedLeftTuples.removeUpdate(childLeftTuple);
                    }
                }
                childLeftTuple.setPropagationContext(leftTuple.getPropagationContext());
                trgLeftTuples.addDelete(childLeftTuple);
            }
            leftTuple.clearStaged();
            leftTuple = next;
        }
    }
}

