/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Traitable;
import org.drools.core.factmodel.traits.TraitableBean;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.PatternBuilder;
import org.drools.core.rule.EntryPointId;
import org.drools.core.rule.TypeDeclaration;
import org.drools.core.spi.Activation;
import org.kie.api.definition.type.Role;

public class ClassObjectTypeConf
implements ObjectTypeConf,
Externalizable {
    protected static final Class<?>[] ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES = new Class[]{PropertyChangeListener.class};
    private static final long serialVersionUID = 510L;
    private Class<?> cls;
    private transient InternalKnowledgeBase kBase;
    private ObjectTypeNode[] objectTypeNodes;
    private ObjectTypeNode concreteObjectTypeNode;
    private EntryPointId entryPoint;
    private TypeDeclaration typeDecl;
    private boolean tmsEnabled;
    private boolean traitTmsEnabled;
    private boolean supportsPropertyListeners;
    private boolean isEvent;
    private boolean isTrait;
    private static final ObjectTypeNodeComparator OBJECT_TYPE_NODE_COMPARATOR = new ObjectTypeNodeComparator();

    public ClassObjectTypeConf() {
    }

    public ClassObjectTypeConf(EntryPointId entryPoint, Class<?> clazz, InternalKnowledgeBase kBase) {
        this.cls = Activation.class.isAssignableFrom(clazz) ? ClassObjectType.Match_ObjectType.getClassType() : clazz;
        this.kBase = kBase;
        this.entryPoint = entryPoint;
        this.typeDecl = kBase.getTypeDeclaration(clazz);
        this.isEvent = this.typeDecl != null && this.typeDecl.getRole() == Role.Type.EVENT;
        this.isTrait = this.determineTraitStatus();
        ClassObjectType objectType = kBase.getClassFieldAccessorCache().getClassObjectType(new ClassObjectType(clazz, this.isEvent), false);
        this.concreteObjectTypeNode = kBase.getRete().getObjectTypeNodes(entryPoint).get(objectType);
        if (this.concreteObjectTypeNode == null) {
            BuildContext context = new BuildContext(kBase, kBase.getReteooBuilder().getIdGenerator());
            context.setCurrentEntryPoint(entryPoint);
            if (DroolsQuery.class == clazz) {
                context.setTupleMemoryEnabled(false);
                context.setObjectTypeNodeMemoryEnabled(false);
            } else if (context.getKnowledgeBase().getConfiguration().isSequential()) {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            } else {
                context.setTupleMemoryEnabled(true);
                context.setObjectTypeNodeMemoryEnabled(true);
            }
            this.concreteObjectTypeNode = PatternBuilder.attachObjectTypeNode(context, objectType);
        }
        this.supportsPropertyListeners = this.checkPropertyListenerSupport(clazz);
        Traitable ttbl = this.cls.getAnnotation(Traitable.class);
        this.traitTmsEnabled = ttbl != null && ttbl.logical();
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        this.kBase = (InternalKnowledgeBase)stream.readObject();
        this.cls = (Class)stream.readObject();
        this.objectTypeNodes = (ObjectTypeNode[])stream.readObject();
        this.concreteObjectTypeNode = (ObjectTypeNode)stream.readObject();
        this.entryPoint = (EntryPointId)stream.readObject();
        this.tmsEnabled = stream.readBoolean();
        this.traitTmsEnabled = stream.readBoolean();
        this.supportsPropertyListeners = stream.readBoolean();
        this.isEvent = stream.readBoolean();
        this.isTrait = stream.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeObject(this.kBase);
        stream.writeObject(this.cls);
        stream.writeObject(this.objectTypeNodes);
        stream.writeObject(this.concreteObjectTypeNode);
        stream.writeObject(this.entryPoint);
        stream.writeBoolean(this.tmsEnabled);
        stream.writeBoolean(this.traitTmsEnabled);
        stream.writeBoolean(this.supportsPropertyListeners);
        stream.writeBoolean(this.isEvent);
        stream.writeBoolean(this.isTrait);
    }

    @Override
    public boolean isAssignableFrom(Object object) {
        return this.cls.isAssignableFrom((Class)object);
    }

    @Override
    public ObjectTypeNode getConcreteObjectTypeNode() {
        return this.concreteObjectTypeNode;
    }

    private boolean checkPropertyListenerSupport(Class<?> clazz) {
        Method method = null;
        try {
            method = clazz.getMethod("addPropertyChangeListener", ADD_REMOVE_PROPERTY_CHANGE_LISTENER_ARG_TYPES);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method != null;
    }

    public static String getPackageName(Class<?> clazz, Package pkg) {
        String pkgName = "";
        if (pkg == null) {
            int index = clazz.getName().lastIndexOf(46);
            if (index != -1) {
                pkgName = clazz.getName().substring(0, index);
            }
        } else {
            pkgName = pkg.getName();
        }
        return pkgName;
    }

    @Override
    public boolean isTraitTMSEnabled() {
        return this.traitTmsEnabled;
    }

    @Override
    public void resetCache() {
        this.objectTypeNodes = null;
    }

    @Override
    public ObjectTypeNode[] getObjectTypeNodes() {
        if (this.objectTypeNodes == null) {
            this.objectTypeNodes = this.getMatchingObjectTypes(this.cls);
        }
        return this.objectTypeNodes;
    }

    private ObjectTypeNode[] getMatchingObjectTypes(Class<?> clazz) {
        ArrayList<ObjectTypeNode> cache = new ArrayList<ObjectTypeNode>();
        for (ObjectTypeNode node : this.kBase.getRete().getObjectTypeNodes(this.entryPoint).values()) {
            if (clazz == DroolsQuery.class) {
                if (((ClassObjectType)node.getObjectType()).getClassType() != clazz) continue;
                cache.add(node);
                continue;
            }
            if (!node.isAssignableFrom(new ClassObjectType(clazz))) continue;
            cache.add(node);
        }
        Collections.sort(cache, OBJECT_TYPE_NODE_COMPARATOR);
        return cache.toArray(new ObjectTypeNode[cache.size()]);
    }

    @Override
    public boolean isActive() {
        return this.getConcreteObjectTypeNode().getSinkPropagator().getSinks().length > 0;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }

    @Override
    public boolean isTrait() {
        return this.isTrait;
    }

    protected boolean determineTraitStatus() {
        return this.typeDecl != null && this.typeDecl.getTypeClass() == this.cls && (this.typeDecl.getKind() == TypeDeclaration.Kind.TRAIT || this.typeDecl.getTypeClassDef().isTraitable() || this.typeDecl.getTypeClass().getAnnotation(Traitable.class) != null) || Thing.class.isAssignableFrom(this.cls) || this.cls.getAnnotation(Traitable.class) != null || TraitableBean.class.isAssignableFrom(this.cls);
    }

    @Override
    public TypeDeclaration getTypeDeclaration() {
        return this.typeDecl;
    }

    @Override
    public boolean isDynamic() {
        return this.typeDecl != null && this.typeDecl.isDynamic();
    }

    @Override
    public boolean isTMSEnabled() {
        return this.tmsEnabled;
    }

    @Override
    public void enableTMS() {
        this.tmsEnabled = true;
    }

    @Override
    public EntryPointId getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public boolean isSupportsPropertyChangeListeners() {
        return this.supportsPropertyListeners;
    }

    public String getClassName() {
        return this.cls != null ? this.cls.getName() : "";
    }

    @Override
    public String getTypeName() {
        return this.getClassName();
    }

    private static final class ObjectTypeNodeComparator
    implements Comparator<ObjectTypeNode> {
        private ObjectTypeNodeComparator() {
        }

        @Override
        public int compare(ObjectTypeNode o1, ObjectTypeNode o2) {
            return o1.getId() - o2.getId();
        }
    }
}

