/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.DroolsObjectOutputStream;
import org.drools.core.util.StringUtils;
import org.kie.api.definition.type.Modifies;
import org.kie.internal.utils.ClassLoaderUtil;

public final class ClassUtils {
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return ClassLoaderUtil.class.getProtectionDomain();
        }
    });
    private static Map<String, Class<?>> classes = Collections.synchronizedMap(new HashMap());
    private static final String STAR = "*";

    public static boolean areNullSafeEquals(Object obj1, Object obj2) {
        return obj1 == null ? obj2 == null : obj1.equals(obj2);
    }

    public static String convertResourceToClassName(String pResourceName) {
        return ClassUtils.stripExtension(pResourceName).replace('/', '.');
    }

    public static String convertClassToResourcePath(Class cls) {
        return ClassUtils.convertClassToResourcePath(cls.getName());
    }

    public static String convertClassToResourcePath(String pName) {
        return pName.replace('.', '/') + ".class";
    }

    public static String stripExtension(String pResourceName) {
        int i = pResourceName.lastIndexOf(46);
        return pResourceName.substring(0, i);
    }

    public static String toJavaCasing(String pName) {
        char[] name = pName.toLowerCase().toCharArray();
        name[0] = Character.toUpperCase(name[0]);
        return new String(name);
    }

    public static String clazzName(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        int p = absFileName.lastIndexOf(46);
        String relFileName = absFileName.substring(rootLength + 1, p);
        return relFileName.replace(File.separatorChar, '.');
    }

    public static String relative(File base, File file) {
        int rootLength = base.getAbsolutePath().length();
        String absFileName = file.getAbsolutePath();
        return absFileName.substring(rootLength + 1);
    }

    public static String canonicalName(Class clazz) {
        StringBuilder name = new StringBuilder();
        if (clazz.isArray()) {
            name.append(ClassUtils.canonicalName(clazz.getComponentType()));
            name.append("[]");
        } else if (clazz.getDeclaringClass() == null) {
            name.append(clazz.getName());
        } else {
            name.append(ClassUtils.canonicalName(clazz.getDeclaringClass()));
            name.append(".");
            name.append(clazz.getName().substring(clazz.getDeclaringClass().getName().length() + 1));
        }
        return name.toString();
    }

    public static Object instantiateObject(String className) {
        return ClassUtils.instantiateObject(className, null);
    }

    public static Object instantiateObject(String className, ClassLoader classLoader) {
        Object object;
        Class<?> cls = classes.get(className);
        if (cls == null) {
            try {
                cls = Class.forName(className);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (cls == null && classLoader != null) {
                try {
                    cls = classLoader.loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = ClassUtils.class.getClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls == null) {
                try {
                    cls = ClassLoader.getSystemClassLoader().loadClass(className);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (cls != null) {
                classes.put(className, cls);
            } else {
                throw new RuntimeException("Unable to load class '" + className + "'");
            }
        }
        try {
            object = cls.newInstance();
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to instantiate object for class '" + className + "'", e);
        }
        return object;
    }

    public static void addImportStylePatterns(Map<String, Object> patterns, String str) {
        String[] items;
        if (str == null || "".equals(str.trim())) {
            return;
        }
        for (String item : items = str.split(" ")) {
            ArrayList<String> list;
            String qualifiedNamespace = item.substring(0, item.lastIndexOf(46)).trim();
            String name = item.substring(item.lastIndexOf(46) + 1).trim();
            Object object = patterns.get(qualifiedNamespace);
            if (object == null) {
                if (STAR.equals(name)) {
                    patterns.put(qualifiedNamespace, STAR);
                    continue;
                }
                list = new ArrayList<String>();
                list.add(name);
                patterns.put(qualifiedNamespace, list);
                continue;
            }
            if (name.equals(STAR)) {
                patterns.put(qualifiedNamespace, STAR);
                continue;
            }
            list = (ArrayList<String>)object;
            if (list.contains(name)) continue;
            list.add(name);
        }
    }

    public static boolean isMatched(Map<String, Object> patterns, String className) {
        String qualifiedNamespace = className;
        String name = className;
        if (className.indexOf(46) > 0) {
            qualifiedNamespace = className.substring(0, className.lastIndexOf(46)).trim();
            name = className.substring(className.lastIndexOf(46) + 1).trim();
        } else if (className.indexOf(91) == 0) {
            qualifiedNamespace = className.substring(0, className.lastIndexOf(91));
        }
        Object object = patterns.get(qualifiedNamespace);
        if (object == null) {
            return true;
        }
        if (STAR.equals(object)) {
            return false;
        }
        if (patterns.containsKey(STAR)) {
            return true;
        }
        List list = (List)object;
        return !list.contains(name);
    }

    public static String getPackage(Class<?> cls) {
        Package pkg;
        Package package_ = pkg = cls.isArray() ? cls.getComponentType().getPackage() : cls.getPackage();
        if (pkg == null) {
            int dolPos = cls.getName().indexOf(36);
            int dotPos = dolPos > 0 ? cls.getName().substring(0, dolPos).lastIndexOf(46) : cls.getName().lastIndexOf(46);
            if (dotPos > 0) {
                return cls.getName().substring(0, dotPos);
            }
            return "";
        }
        return pkg.getName();
    }

    public static Class<?> findClass(String name, Collection<String> availableImports, ClassLoader cl) {
        Class<?> clazz = null;
        for (String imp : availableImports) {
            String className;
            if (imp.endsWith(".*")) {
                imp = imp.substring(0, imp.length() - 2);
            }
            if ((clazz = ClassUtils.findClass(className = imp.endsWith(name) ? imp : imp + "." + name, cl)) == null) continue;
            break;
        }
        return clazz;
    }

    public static Class<?> findClass(String className, ClassLoader cl) {
        try {
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            int lastDot = className.lastIndexOf(46);
            className = className.substring(0, lastDot) + "$" + className.substring(lastDot + 1);
            try {
                return Class.forName(className, false, cl);
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    public static List<String> getSettableProperties(Class<?> clazz) {
        TreeSet<SetterInClass> props = new TreeSet<SetterInClass>();
        for (Method method : clazz.getMethods()) {
            String propName;
            if (method.getParameterTypes().length == 1 && (propName = ClassUtils.setter2property(method.getName())) != null) {
                props.add(new SetterInClass(propName, method.getDeclaringClass()));
            }
            ClassUtils.processModifiesAnnotation(clazz, props, method);
        }
        for (AccessibleObject accessibleObject : clazz.getFields()) {
            if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            props.add(new SetterInClass(((Field)accessibleObject).getName(), ((Field)accessibleObject).getDeclaringClass()));
        }
        ArrayList<String> settableProperties = new ArrayList<String>();
        for (SetterInClass setter : props) {
            settableProperties.add(setter.setter);
        }
        return settableProperties;
    }

    public static Method getAccessor(Class<?> clazz, String field) {
        try {
            return clazz.getMethod("get" + StringUtils.ucFirst(field), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(field, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                try {
                    return clazz.getMethod("is" + StringUtils.ucFirst(field), new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    return null;
                }
            }
        }
    }

    private static void processModifiesAnnotation(Class<?> clazz, Set<SetterInClass> props, Method m) {
        Modifies modifies = m.getAnnotation(Modifies.class);
        if (modifies != null) {
            for (String prop : modifies.value()) {
                prop = prop.trim();
                try {
                    Field field = clazz.getField(prop);
                    props.add(new SetterInClass(field.getName(), field.getDeclaringClass()));
                }
                catch (NoSuchFieldException e) {
                    String getter = "get" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                    try {
                        Method method = clazz.getMethod(getter, new Class[0]);
                        props.add(new SetterInClass(prop, method.getDeclaringClass()));
                    }
                    catch (NoSuchMethodException e1) {
                        getter = "is" + prop.substring(0, 1).toUpperCase() + prop.substring(1);
                        try {
                            Method method = clazz.getMethod(getter, new Class[0]);
                            props.add(new SetterInClass(prop, method.getDeclaringClass()));
                        }
                        catch (NoSuchMethodException e2) {
                            throw new RuntimeException(e2);
                        }
                    }
                }
            }
        }
    }

    public static boolean isTypeCompatibleWithArgumentType(Class actual, Class formal) {
        if (actual.isPrimitive() && formal.isPrimitive()) {
            return ClassUtils.isConvertible(actual, formal);
        }
        if (actual.isPrimitive()) {
            return ClassUtils.isConvertible(actual, ClassUtils.convertToPrimitiveType(formal));
        }
        if (formal.isPrimitive()) {
            return ClassUtils.isConvertible(ClassUtils.convertToPrimitiveType(actual), formal);
        }
        return formal.isAssignableFrom(actual);
    }

    public static boolean isConvertible(Class srcPrimitive, Class tgtPrimitive) {
        if (Boolean.TYPE.equals(srcPrimitive)) {
            return Boolean.TYPE.equals(tgtPrimitive);
        }
        if (Byte.TYPE.equals(tgtPrimitive)) {
            return Byte.TYPE.equals(tgtPrimitive) || Short.TYPE.equals(tgtPrimitive) || Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Character.TYPE.equals(srcPrimitive)) {
            return Character.TYPE.equals(tgtPrimitive) || Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Double.TYPE.equals(srcPrimitive)) {
            return Double.TYPE.equals(tgtPrimitive);
        }
        if (Float.TYPE.equals(srcPrimitive)) {
            return Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Integer.TYPE.equals(srcPrimitive)) {
            return Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Long.TYPE.equals(srcPrimitive)) {
            return Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        if (Short.TYPE.equals(srcPrimitive)) {
            return Short.TYPE.equals(tgtPrimitive) || Integer.TYPE.equals(tgtPrimitive) || Long.TYPE.equals(tgtPrimitive) || Float.TYPE.equals(tgtPrimitive) || Double.TYPE.equals(tgtPrimitive);
        }
        return false;
    }

    public static String getter2property(String methodName) {
        if (methodName.startsWith("get") && methodName.length() > 3) {
            return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
        }
        if (methodName.startsWith("is") && methodName.length() > 2) {
            return Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3);
        }
        return null;
    }

    public static String setter2property(String methodName) {
        if (!methodName.startsWith("set") || methodName.length() < 4) {
            return null;
        }
        return Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
    }

    public static <T extends Externalizable> T deepClone(T origin) {
        return origin == null ? null : (T)ClassUtils.deepClone(origin, origin.getClass().getClassLoader());
    }

    public static <T extends Externalizable> T deepClone(T origin, ClassLoader classLoader) {
        if (origin == null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DroolsObjectOutputStream oos = new DroolsObjectOutputStream(baos);
            oos.writeObject(origin);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            DroolsObjectInputStream ois = new DroolsObjectInputStream(bais, classLoader);
            Object deepCopy = ois.readObject();
            return (T)((Externalizable)deepCopy);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }

    public static Class<?> convertFromPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new RuntimeException("Class not convertible from primitive: " + type.getName());
    }

    public static Class<?> convertToPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            return type;
        }
        if (type == Integer.class) {
            return Integer.TYPE;
        }
        if (type == Long.class) {
            return Long.TYPE;
        }
        if (type == Float.class) {
            return Float.TYPE;
        }
        if (type == Double.class) {
            return Double.TYPE;
        }
        if (type == Short.class) {
            return Short.TYPE;
        }
        if (type == Byte.class) {
            return Byte.TYPE;
        }
        if (type == Character.class) {
            return Character.TYPE;
        }
        if (type == Boolean.class) {
            return Boolean.TYPE;
        }
        if (type == BigInteger.class) {
            return Long.TYPE;
        }
        if (type == BigDecimal.class) {
            return Double.TYPE;
        }
        if (type == Number.class) {
            return Double.TYPE;
        }
        throw new RuntimeException("Class not convertible to primitive: " + type.getName());
    }

    public static Class<?> convertPrimitiveNameToType(String typeName) {
        if (typeName.equals("int")) {
            return Integer.TYPE;
        }
        if (typeName.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (typeName.equals("char")) {
            return Character.TYPE;
        }
        if (typeName.equals("byte")) {
            return Byte.TYPE;
        }
        if (typeName.equals("short")) {
            return Short.TYPE;
        }
        if (typeName.equals("float")) {
            return Float.TYPE;
        }
        if (typeName.equals("long")) {
            return Long.TYPE;
        }
        if (typeName.equals("double")) {
            return Double.TYPE;
        }
        return Object.class;
    }

    public static Set<Class<?>> getAllImplementedInterfaceNames(Class<?> klass) {
        HashSet interfaces = new HashSet();
        while (klass != null) {
            Class<?>[] localInterfaces;
            for (Class<?> intf : localInterfaces = klass.getInterfaces()) {
                interfaces.add(intf);
                ClassUtils.exploreSuperInterfaces(intf, interfaces);
            }
            klass = klass.getSuperclass();
        }
        return interfaces;
    }

    private static void exploreSuperInterfaces(Class<?> intf, Set<Class<?>> traitInterfaces) {
        for (Class<?> sup : intf.getInterfaces()) {
            traitInterfaces.add(sup);
            ClassUtils.exploreSuperInterfaces(sup, traitInterfaces);
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toUpperCase().contains("WINDOWS");
    }

    public static boolean isOSX() {
        String os = System.getProperty("os.name");
        return os.toUpperCase().contains("MAC OS X");
    }

    public static class MapClassLoader
    extends ClassLoader {
        private Map<String, byte[]> map;

        public MapClassLoader(Map<String, byte[]> map, ClassLoader parent) {
            super(parent);
            this.map = map;
        }

        @Override
        public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> cls = this.fastFindClass(name);
            if (cls == null) {
                cls = super.loadClass(name, resolve);
            }
            if (cls == null) {
                throw new ClassNotFoundException("Unable to load class: " + name);
            }
            return cls;
        }

        public Class<?> fastFindClass(String name) {
            Class<?> cls = this.findLoadedClass(name);
            if (cls == null) {
                byte[] clazzBytes = this.map.get(ClassUtils.convertClassToResourcePath(name));
                if (clazzBytes != null) {
                    String pkgName;
                    int lastDotPos = name.lastIndexOf(46);
                    String string = pkgName = lastDotPos > 0 ? name.substring(0, lastDotPos) : "";
                    if (this.getPackage(pkgName) == null) {
                        this.definePackage(pkgName, "", "", "", "", "", "", null);
                    }
                    cls = this.defineClass(name, clazzBytes, 0, clazzBytes.length, PROTECTION_DOMAIN);
                }
                if (cls != null) {
                    this.resolveClass(cls);
                }
            }
            return cls;
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            byte[] clsBytes = this.map.get(name);
            if (clsBytes != null) {
                return new ByteArrayInputStream(clsBytes);
            }
            return null;
        }

        @Override
        public URL getResource(String name) {
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return new Enumeration<URL>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public URL nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
    }

    private static class SetterInClass
    implements Comparable {
        private final String setter;
        private final Class<?> clazz;

        private SetterInClass(String setter, Class<?> clazz) {
            this.setter = setter;
            this.clazz = clazz;
        }

        public int compareTo(Object o) {
            SetterInClass other = (SetterInClass)o;
            if (this.clazz == other.clazz) {
                return this.setter.compareTo(other.setter);
            }
            return this.clazz.isAssignableFrom(other.clazz) ? -1 : 1;
        }

        public boolean equals(Object obj) {
            SetterInClass other = (SetterInClass)obj;
            return this.clazz == other.clazz && this.setter.equals(other.setter);
        }

        public int hashCode() {
            return 29 * this.clazz.hashCode() + 31 * this.setter.hashCode();
        }
    }
}

