/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.dsl.editor;

import java.io.Reader;
import org.drools.compiler.lang.dsl.DSLTokenizedMappingFile;
import org.drools.compiler.lang.dsl.DefaultExpander;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.dsl.editor.DSLAdapter;
import org.drools.eclipse.dsl.editor.DSLRuleEditor;
import org.drools.eclipse.dsl.editor.DSLtoDRLRuleViewer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;

public class DSLRuleEditor2
extends FormEditor {
    private DSLRuleEditor dslRuleEditor;
    private DSLtoDRLRuleViewer drlRuleViewer;
    private int selection;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
    }

    protected void addPages() {
        try {
            this.dslRuleEditor = new DSLRuleEditor(){

                public void close(boolean save) {
                    super.close(save);
                    DSLRuleEditor2.this.close(save);
                }

                protected void setPartName(String partName) {
                    super.setPartName(partName);
                    DSLRuleEditor2.this.setPartName(partName);
                }
            };
            int text = this.addPage((IEditorPart)this.dslRuleEditor, this.getEditorInput());
            this.setPageText(text, "Text Editor");
            this.drlRuleViewer = new DSLtoDRLRuleViewer(this.dslRuleEditor);
            text = this.addPage((IEditorPart)this.drlRuleViewer, this.getEditorInput());
            this.setPageText(text, "DRL Viewer");
        }
        catch (PartInitException e) {
            DroolsEclipsePlugin.log(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.dslRuleEditor.doSave(monitor);
        this.setInput(this.getEditorInput());
    }

    public void doSaveAs() {
        this.dslRuleEditor.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.dslRuleEditor.isSaveAsAllowed();
    }

    public Object getAdapter(Class adapter) {
        return this.dslRuleEditor.getAdapter(adapter);
    }

    public void setFocus() {
        if (this.getActivePage() == 1) {
            try {
                DefaultExpander expander = new DefaultExpander();
                String content = this.dslRuleEditor.getContent();
                Reader reader = DSLAdapter.getDSLContent(content, this.dslRuleEditor.getResource());
                if (reader == null) {
                    throw new IllegalArgumentException("Could not find dsl definition.");
                }
                DSLTokenizedMappingFile mapping = new DSLTokenizedMappingFile();
                mapping.parseAndLoad(reader);
                reader.close();
                expander.addDSLMapping(mapping.getMapping());
                expander.expand(content);
                this.drlRuleViewer.setInput(this.getEditorInput());
                this.drlRuleViewer.setSelectedRange(this.selection);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.handleError(t);
                this.setActivePage(0);
            }
        } else if (this.getActivePage() == 0) {
            this.selection = this.drlRuleViewer.getSelectedRange();
        }
        super.setFocus();
    }

    private void handleError(Throwable t) {
        String message;
        DroolsEclipsePlugin.log(t);
        Throwable cause = t.getCause();
        if (cause == null) {
            cause = t;
        }
        if ((message = String.valueOf(cause.getClass().getName()) + ": " + cause.getMessage()) == null || message.length() == 0) {
            message = "Uncategorized Error!";
        }
        Status status = new Status(4, DroolsEclipsePlugin.getUniqueIdentifier(), -1, message, null);
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"DSL Rule Translation Error!", (String)"DSL Rule Translation Error!", (IStatus)status);
    }
}

