/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event.rule.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.impl.SerializedRule;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.PropagationContext;

public class SerializablePropagationContext
implements PropagationContext,
Externalizable {
    private FactHandle factHandle;
    private long propgationNumber;
    private Rule rule;
    private int type;

    public SerializablePropagationContext() {
    }

    public SerializablePropagationContext(PropagationContext propagationContext) {
        this.factHandle = propagationContext.getFactHandle();
        this.propgationNumber = propagationContext.getPropagationNumber();
        this.rule = propagationContext.getRule();
        this.type = propagationContext.getType();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.factHandle);
        out.writeLong(this.propgationNumber);
        new SerializedRule(this.rule).writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.factHandle = (FactHandle)in.readObject();
        this.propgationNumber = in.readLong();
        this.rule = new SerializedRule();
        ((SerializedRule)this.rule).readExternal(in);
    }

    public FactHandle getFactHandle() {
        return this.factHandle;
    }

    public long getPropagationNumber() {
        return this.propgationNumber;
    }

    public Rule getRule() {
        return this.rule;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "==>[SerializablePropagationContext: getFactHandle()=" + this.getFactHandle() + ", getPropagationNumber()=" + this.getPropagationNumber() + ", getRule()=" + this.getRule() + ", getType()=" + this.getType() + "]";
    }
}

