/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler.io.memory;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.drools.compiler.compiler.io.File;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.Path;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.compiler.io.memory.MemoryPath;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;

public class MemoryFile
implements File {
    private String name;
    private Folder folder;
    private MemoryFileSystem mfs;

    public MemoryFile(MemoryFileSystem mfs, String name, Folder folder) {
        this.name = name;
        this.folder = folder;
        this.mfs = mfs;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public InputStream getContents() throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exist, unable to open InputStream");
        }
        return new ByteArrayInputStream(this.mfs.getFileContents(this));
    }

    @Override
    public Path getPath() {
        return this.getRelativePath();
    }

    public Path getRelativePath() {
        if (!StringUtils.isEmpty((CharSequence)this.folder.getPath().toPortableString())) {
            return new MemoryPath(this.folder.getPath().toPortableString() + "/" + this.name);
        }
        return new MemoryPath(this.name);
    }

    public Folder getFolder() {
        return this.folder;
    }

    @Override
    public boolean exists() {
        return this.mfs.existsFile(this.getRelativePath().toPortableString());
    }

    @Override
    public void setContents(InputStream is) throws IOException {
        if (!this.exists()) {
            throw new IOException("File does not exists, cannot set contents");
        }
        this.mfs.setFileContents(this, StringUtils.toString((InputStream)is).getBytes(IoUtils.UTF8_CHARSET));
    }

    @Override
    public void create(InputStream is) throws IOException {
        this.mfs.setFileContents(this, IoUtils.readBytesFromInputStream((InputStream)is));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.folder == null ? 0 : this.folder.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryFile other = (MemoryFile)obj;
        if (this.folder == null ? other.folder != null : !this.folder.equals(other.folder)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "MemoryFile [name=" + this.name + ", folder=" + this.folder + "]";
    }
}

