/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.query;

import java.util.Date;
import java.util.List;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.command.AuditCommand;
import org.jbpm.query.jpa.builder.impl.AbstractQueryBuilderImpl;
import org.jbpm.query.jpa.data.QueryWhere;
import org.kie.api.runtime.CommandExecutor;
import org.kie.internal.command.Context;
import org.kie.internal.query.ParametrizedQuery;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.kie.internal.runtime.manager.audit.query.AuditLogQueryBuilder;

public abstract class AbstractAuditQueryBuilderImpl<T, R>
extends AbstractQueryBuilderImpl<T>
implements AuditLogQueryBuilder<T, R> {
    protected final CommandExecutor executor;
    protected final JPAAuditLogService jpaAuditService;
    private AuditCommand<JPAAuditLogService> getJpaAuditLogServiceCommand = new AuditCommand<JPAAuditLogService>(){
        private static final long serialVersionUID = 101L;

        public JPAAuditLogService execute(Context context) {
            this.setLogEnvironment(context);
            return (JPAAuditLogService)this.auditLogService;
        }
    };

    protected AbstractAuditQueryBuilderImpl(JPAAuditLogService jpaService) {
        this.executor = null;
        this.jpaAuditService = jpaService;
    }

    protected AbstractAuditQueryBuilderImpl(CommandExecutor cmdExecutor) {
        this.executor = cmdExecutor;
        this.jpaAuditService = null;
    }

    protected JPAAuditLogService getJpaAuditLogService() {
        JPAAuditLogService jpaAuditLogService = this.jpaAuditService;
        if (jpaAuditLogService == null) {
            jpaAuditLogService = (JPAAuditLogService)this.executor.execute(this.getJpaAuditLogServiceCommand);
        }
        return jpaAuditLogService;
    }

    public T processInstanceId(long ... processInstanceId) {
        this.addLongParameter(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceId);
        return (T)((Object)this);
    }

    public T processInstanceIdRange(Long processInstanceIdMin, Long processInstanceIdMax) {
        this.addRangeParameters(QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST, "process instance id", processInstanceIdMin, processInstanceIdMax);
        return (T)((Object)this);
    }

    public T processId(String ... processId) {
        this.addObjectParameter(QueryParameterIdentifiers.PROCESS_ID_LIST, "process id", processId);
        return (T)((Object)this);
    }

    public T date(Date ... date) {
        this.addObjectParameter(QueryParameterIdentifiers.DATE_LIST, "date", date);
        return (T)((Object)this);
    }

    public T dateRangeStart(Date rangeStart) {
        this.addRangeParameter(QueryParameterIdentifiers.DATE_LIST, "date range start", rangeStart, true);
        return (T)((Object)this);
    }

    public T dateRangeEnd(Date rangeStart) {
        this.addRangeParameter(QueryParameterIdentifiers.DATE_LIST, "date range end", rangeStart, false);
        return (T)((Object)this);
    }

    public T ascending(AuditLogQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setAscending(listId);
        return (T)((Object)this);
    }

    public T descending(AuditLogQueryBuilder.OrderBy field) {
        String listId = this.convertOrderByToListId(field);
        this.queryWhere.setDescending(listId);
        return (T)((Object)this);
    }

    private String convertOrderByToListId(AuditLogQueryBuilder.OrderBy field) {
        String listId;
        switch (field) {
            case processId: {
                listId = QueryParameterIdentifiers.PROCESS_ID_LIST;
                break;
            }
            case processInstanceId: {
                listId = QueryParameterIdentifiers.PROCESS_INSTANCE_ID_LIST;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown 'order-by' field: " + field.toString());
            }
        }
        return listId;
    }

    protected abstract Class<R> getResultType();

    protected abstract Class getQueryType();

    public ParametrizedQuery<R> build() {
        return new ParametrizedQuery<R>(){
            private QueryWhere queryData;
            {
                this.queryData = new QueryWhere(AbstractAuditQueryBuilderImpl.this.getQueryWhere());
            }

            public List<R> getResultList() {
                return AbstractAuditQueryBuilderImpl.this.getJpaAuditLogService().queryLogs(this.queryData, AbstractAuditQueryBuilderImpl.this.getQueryType(), AbstractAuditQueryBuilderImpl.this.getResultType());
            }
        };
    }
}

