/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.server.jbpm60;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieProjectHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.KieOrganizationHandler;
import org.kie.eclipse.server.KieProjectHandler;
import org.kie.eclipse.server.KieRepositoryHandler;
import org.kie.eclipse.server.KieServiceDelegate;

public class Kie60Service
extends KieServiceDelegate {
    @Override
    public List<IKieOrganizationHandler> getOrganizations(IKieServerHandler service) throws IOException {
        ArrayList<IKieOrganizationHandler> result = new ArrayList<IKieOrganizationHandler>();
        String response = this.httpGet("organizationalunits");
        JsonArray ja = JsonArray.readFrom(response);
        int i = 0;
        while (i < ja.size()) {
            JsonObject jo = ja.get(i).asObject();
            KieOrganizationHandler ko = new KieOrganizationHandler(service, jo.get("name").asString());
            ko.setProperties(jo);
            result.add(ko);
            ++i;
        }
        return result;
    }

    @Override
    public List<IKieRepositoryHandler> getRepositories(IKieOrganizationHandler organization) throws IOException {
        IKieServerHandler server = (IKieServerHandler)organization.getRoot();
        List<IKieRepositoryHandler> allRepositories = this.getRepositories(server);
        ArrayList<IKieRepositoryHandler> result = new ArrayList<IKieRepositoryHandler>();
        String response = this.httpGet("organizationalunits");
        JsonArray ja1 = JsonArray.readFrom(response);
        int i = 0;
        while (i < ja1.size()) {
            JsonObject jo = ja1.get(i).asObject();
            if (organization.getName().equals(jo.get("name").asString())) {
                JsonArray ja2 = jo.get("repositories").asArray();
                int j = 0;
                while (j < ja2.size()) {
                    JsonValue jv = ja2.get(j);
                    String name = jv.asString();
                    for (IKieRepositoryHandler r : allRepositories) {
                        if (!r.getName().equals(name)) continue;
                        r.setParent(organization);
                        result.add(r);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public List<IKieRepositoryHandler> getRepositories(IKieServerHandler server) throws IOException {
        ArrayList<IKieRepositoryHandler> result = new ArrayList<IKieRepositoryHandler>();
        String response = this.httpGet("repositories");
        JsonArray ja1 = JsonArray.readFrom(response);
        int i = 0;
        while (i < ja1.size()) {
            JsonObject jo = ja1.get(i).asObject();
            KieRepositoryHandler kr = new KieRepositoryHandler(server, jo.get("name").asString());
            kr.setProperties(jo);
            result.add(kr);
            ++i;
        }
        return result;
    }

    @Override
    public List<IKieProjectHandler> getProjects(IKieRepositoryHandler repository) throws IOException {
        ArrayList<IKieProjectHandler> result = new ArrayList<IKieProjectHandler>();
        String response = this.httpGet("repositories/" + repository.getName() + "/projects/");
        JsonArray ja1 = JsonArray.readFrom(response);
        int i = 0;
        while (i < ja1.size()) {
            JsonObject jo = ja1.get(i).asObject();
            KieProjectHandler kp = new KieProjectHandler(repository, jo.get("name").asString());
            kp.setProperties(jo);
            result.add(kp);
            ++i;
        }
        return result;
    }

    @Override
    public void createOrganization(IKieOrganizationHandler organization) throws IOException {
        String jobId = this.httpPost("organizationalunits", organization.getProperties());
        try {
            String status = this.getJobStatus(jobId, "Creating Organization '" + organization.getName() + "'");
            if (status == null) {
                throw new IOException("Request to create Organization '" + organization.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to create Organization '" + organization.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to create Organization '" + organization.getName() + "' was canceled");
        }
    }

    @Override
    public void createRepository(IKieRepositoryHandler repository) throws IOException {
        String jobId = this.httpPost("repositories", repository.getProperties());
        try {
            String status = this.getJobStatus(jobId, "Creating Repository '" + repository.getName() + "'");
            if (status == null) {
                throw new IOException("Request to create Repository '" + repository.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to create Repository '" + repository.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to create Repository '" + repository.getName() + "' was canceled");
        }
    }

    @Override
    public void addRepository(IKieRepositoryHandler repository, IKieOrganizationHandler organization) throws IOException {
        String jobId = this.httpPost("organizationalunits/" + organization.getName() + "/repositories/" + repository.getName(), null);
        try {
            String status = this.getJobStatus(jobId, "Adding Repository '" + repository.getName() + "'");
            if (status == null) {
                throw new IOException("Request to add Repository '" + repository.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to add Repository '" + repository.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to add Repository '" + repository.getName() + "' was canceled");
        }
    }

    @Override
    public void createProject(IKieProjectHandler project) throws IOException {
        String jobId = this.httpPost("repositories/" + project.getParent().getName() + "/projects/", project.getProperties());
        try {
            String status = this.getJobStatus(jobId, "Creating Project '" + project.getName() + "'");
            if (status == null) {
                throw new IOException("Request to create Project '" + project.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to create Project '" + project.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to create Project '" + project.getName() + "' was canceled");
        }
    }

    @Override
    public void deleteOrganization(IKieOrganizationHandler organization) throws IOException {
        String jobId = this.httpDelete("organizationalunits/" + organization.getName());
        try {
            String status = this.getJobStatus(jobId, "Deleting Organization '" + organization.getName() + "'");
            if (status == null) {
                throw new IOException("Request to delete Organization '" + organization.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to delete Organization '" + organization.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to delete Organization '" + organization.getName() + "' was canceled");
        }
    }

    @Override
    public void deleteRepository(IKieRepositoryHandler repository, boolean removeOnly) throws IOException {
        String jobId;
        if (removeOnly) {
            String organization = repository.getParent().getName();
            jobId = this.httpDelete("organizationalunits/" + organization + "/repositories/" + repository.getName());
        } else {
            jobId = this.httpDelete("repositories/" + repository.getName());
        }
        try {
            String status = this.getJobStatus(jobId, "Deleting Repository '" + repository.getName() + "'");
            if (status == null) {
                throw new IOException("Request to delete Repository '" + repository.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to delete Repository '" + repository.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to delete Repository '" + repository.getName() + "' was canceled");
        }
    }

    @Override
    public void deleteProject(IKieProjectHandler project) throws IOException {
        String jobId = this.httpDelete("repositories/" + project.getParent().getName() + "/projects/" + project.getName());
        try {
            String status = this.getJobStatus(jobId, "Deleting project '" + project.getName() + "'");
            if (status == null) {
                throw new IOException("Request to delete project '" + project.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to delete project '" + project.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to delete project '" + project.getName() + "' was canceled");
        }
    }

    @Override
    public void updateOrganization(String oldName, IKieOrganizationHandler organization) throws IOException {
        JsonObject properties = new JsonObject(organization.getProperties());
        properties.remove("repositories");
        String jobId = this.httpPost("organizationalunits/" + oldName, properties);
        try {
            String status = this.getJobStatus(jobId, "Updating Organization '" + organization.getName() + "'");
            if (status == null) {
                throw new IOException("Request to update Organization '" + organization.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to update Organization '" + organization.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to update Organization '" + organization.getName() + "' was canceled");
        }
    }

    @Override
    public void updateRepository(String oldName, IKieRepositoryHandler repository) throws IOException {
    }

    @Override
    public void updateProject(String oldName, IKieProjectHandler project) throws IOException {
    }

    public void mavenCompile(IKieProjectHandler project, JsonObject params) throws IOException {
        String jobId = this.httpPost("repositories/" + project.getParent().getName() + "/projects/" + "/maven/compile/", params);
        try {
            String status = this.getJobStatus(jobId, "Compiling Project '" + project.getName() + "'");
            if (status == null) {
                throw new IOException("Request to compile Project '" + project.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to compile Project '" + project.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to compile Project '" + project.getName() + "' was canceled");
        }
    }

    public void mavenInstall(IKieProjectHandler project, JsonObject params) throws IOException {
        String jobId = this.httpPost("repositories/" + project.getParent().getName() + "/projects/" + "/maven/install/", params);
        try {
            String status = this.getJobStatus(jobId, "Installing Project '" + project.getName() + "'");
            if (status == null) {
                throw new IOException("Request to install Project '" + project.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to install Project '" + project.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to install Project '" + project.getName() + "' was canceled");
        }
    }

    public void mavenTest(IKieProjectHandler project, JsonObject params) throws IOException {
        String jobId = this.httpPost("repositories/" + project.getParent().getName() + "/projects/" + "/maven/test/", params);
        try {
            String status = this.getJobStatus(jobId, "Testing Project '" + project.getName() + "'");
            if (status == null) {
                throw new IOException("Request to test Project '" + project.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to test Project '" + project.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to test Project '" + project.getName() + "' was canceled");
        }
    }

    public void mavenDeploy(IKieProjectHandler project, JsonObject params) throws IOException {
        String jobId = this.httpPost("repositories/" + project.getParent().getName() + "/projects/" + "/maven/deploy/", params);
        try {
            String status = this.getJobStatus(jobId, "Deploying Project '" + project.getName() + "'");
            if (status == null) {
                throw new IOException("Request to deploy Project '" + project.getName() + "' has timed out");
            }
            if (!status.startsWith("SUCCESS")) {
                throw new IOException("Request to deploy Project '" + project.getName() + "' has failed with status " + status);
            }
        }
        catch (InterruptedException interruptedException) {
            this.deleteJob(jobId);
            throw new IOException("Request to deploy Project '" + project.getName() + "' was canceled");
        }
    }
}

