/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTable;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTTableColumn;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.TableDocument;

public class XSSFTable
extends POIXMLDocumentPart {
    private CTTable ctTable;
    private List<XSSFXmlColumnPr> xmlColumnPr;
    private CellReference startCellReference;
    private CellReference endCellReference;
    private String commonXPath;

    public XSSFTable() {
        this.ctTable = CTTable.Factory.newInstance();
    }

    public XSSFTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            TableDocument doc = TableDocument.Factory.parse((InputStream)is);
            this.ctTable = doc.getTable();
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public XSSFSheet getXSSFSheet() {
        return (XSSFSheet)this.getParent();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.updateHeaders();
        TableDocument doc = TableDocument.Factory.newInstance();
        doc.setTable(this.ctTable);
        doc.save(out, DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public CTTable getCTTable() {
        return this.ctTable;
    }

    public boolean mapsTo(long id) {
        boolean maps = false;
        List<XSSFXmlColumnPr> pointers = this.getXmlColumnPrs();
        for (XSSFXmlColumnPr pointer : pointers) {
            if (pointer.getMapId() != id) continue;
            maps = true;
            break;
        }
        return maps;
    }

    public String getCommonXpath() {
        if (this.commonXPath == null) {
            String[] commonTokens = new String[]{};
            block0: for (CTTableColumn column : this.ctTable.getTableColumns().getTableColumnArray()) {
                if (column.getXmlColumnPr() == null) continue;
                String xpath = column.getXmlColumnPr().getXpath();
                String[] tokens = xpath.split("/");
                if (commonTokens.length == 0) {
                    commonTokens = tokens;
                    continue;
                }
                int maxLenght = commonTokens.length > tokens.length ? tokens.length : commonTokens.length;
                for (int i = 0; i < maxLenght; ++i) {
                    if (commonTokens[i].equals(tokens[i])) continue;
                    List<String> subCommonTokens = Arrays.asList(commonTokens).subList(0, i);
                    String[] container = new String[]{};
                    commonTokens = subCommonTokens.toArray(container);
                    continue block0;
                }
            }
            this.commonXPath = "";
            for (int i = 1; i < commonTokens.length; ++i) {
                this.commonXPath = this.commonXPath + "/" + commonTokens[i];
            }
        }
        return this.commonXPath;
    }

    public List<XSSFXmlColumnPr> getXmlColumnPrs() {
        if (this.xmlColumnPr == null) {
            this.xmlColumnPr = new ArrayList<XSSFXmlColumnPr>();
            for (CTTableColumn column : this.ctTable.getTableColumns().getTableColumnArray()) {
                if (column.getXmlColumnPr() == null) continue;
                XSSFXmlColumnPr columnPr = new XSSFXmlColumnPr(this, column, column.getXmlColumnPr());
                this.xmlColumnPr.add(columnPr);
            }
        }
        return this.xmlColumnPr;
    }

    public String getName() {
        return this.ctTable.getName();
    }

    public void setName(String name) {
        if (name == null) {
            this.ctTable.unsetName();
            return;
        }
        this.ctTable.setName(name);
    }

    public String getDisplayName() {
        return this.ctTable.getDisplayName();
    }

    public void setDisplayName(String name) {
        this.ctTable.setDisplayName(name);
    }

    public long getNumerOfMappedColumns() {
        return this.ctTable.getTableColumns().getCount();
    }

    public CellReference getStartCellReference() {
        String ref;
        if (this.startCellReference == null && (ref = this.ctTable.getRef()) != null) {
            String[] boundaries = ref.split(":");
            String from = boundaries[0];
            this.startCellReference = new CellReference(from);
        }
        return this.startCellReference;
    }

    public CellReference getEndCellReference() {
        if (this.endCellReference == null) {
            String ref = this.ctTable.getRef();
            String[] boundaries = ref.split(":");
            String from = boundaries[1];
            this.endCellReference = new CellReference(from);
        }
        return this.endCellReference;
    }

    public int getRowCount() {
        CellReference from = this.getStartCellReference();
        CellReference to = this.getEndCellReference();
        int rowCount = -1;
        if (from != null && to != null) {
            rowCount = to.getRow() - from.getRow();
        }
        return rowCount;
    }

    public void updateHeaders() {
        XSSFSheet sheet = (XSSFSheet)this.getParent();
        CellReference ref = this.getStartCellReference();
        if (ref == null) {
            return;
        }
        int headerRow = ref.getRow();
        int firstHeaderColumn = ref.getCol();
        XSSFRow row = sheet.getRow(headerRow);
        if (row != null && row.getCTRow().validate()) {
            int cellnum = firstHeaderColumn;
            for (CTTableColumn col : this.getCTTable().getTableColumns().getTableColumnArray()) {
                XSSFCell cell = row.getCell(cellnum);
                if (cell != null) {
                    col.setName(cell.getStringCellValue());
                }
                ++cellnum;
            }
        }
    }
}

