/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.compiler.compiler.xml.XmlDumper;
import org.drools.core.process.core.datatype.DataType;
import org.drools.core.process.core.datatype.impl.type.BooleanDataType;
import org.drools.core.process.core.datatype.impl.type.FloatDataType;
import org.drools.core.process.core.datatype.impl.type.IntegerDataType;
import org.drools.core.process.core.datatype.impl.type.ObjectDataType;
import org.drools.core.process.core.datatype.impl.type.StringDataType;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.core.Lane;
import org.jbpm.bpmn2.core.SequenceFlow;
import org.jbpm.bpmn2.core.Signal;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.impl.ExtendedNodeImpl;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.ForEachNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractNodeHandler
extends BaseAbstractHandler
implements Handler {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractNodeHandler.class);
    static final String PROCESS_INSTANCE_SIGNAL_EVENT = "kcontext.getProcessInstance().signalEvent(";
    static final String RUNTIME_SIGNAL_EVENT = "kcontext.getKnowledgeRuntime().signalEvent(";
    static final String RUNTIME_MANAGER_SIGNAL_EVENT = "((org.kie.api.runtime.manager.RuntimeManager)kcontext.getKnowledgeRuntime().getEnvironment().get(\"RuntimeManager\")).signalEvent(";
    protected static final String EOL = System.getProperty("line.separator");
    protected Map<String, String> dataInputs = new HashMap<String, String>();
    protected Map<String, String> dataOutputs = new HashMap<String, String>();
    protected Map<String, String> inputAssociation = new HashMap<String, String>();
    protected Map<String, String> outputAssociation = new HashMap<String, String>();

    public AbstractNodeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = true;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(org.jbpm.workflow.core.NodeContainer.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Variable.class);
        this.validPeers.add(org.jbpm.workflow.core.Node.class);
        this.validPeers.add(SequenceFlow.class);
        this.validPeers.add(Lane.class);
        this.validPeers.add(Association.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        org.jbpm.workflow.core.Node node = this.createNode(attrs);
        String id = attrs.getValue("id");
        node.setMetaData("UniqueId", (Object)id);
        String name = attrs.getValue("name");
        node.setName(name);
        if ("true".equalsIgnoreCase(System.getProperty("jbpm.v5.id.strategy"))) {
            try {
                id = id.substring(1);
                id = id.substring(id.lastIndexOf("-") + 1);
                node.setId((long)Integer.parseInt(id));
            }
            catch (NumberFormatException e) {
                long newId = 0L;
                org.jbpm.workflow.core.NodeContainer nodeContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
                for (Node n : nodeContainer.getNodes()) {
                    if (n.getId() <= newId) continue;
                    newId = n.getId();
                }
                node.setId(++newId);
            }
        } else {
            AtomicInteger idGen = (AtomicInteger)parser.getMetaData().get("idGen");
            node.setId((long)idGen.getAndIncrement());
        }
        return node;
    }

    protected abstract org.jbpm.workflow.core.Node createNode(Attributes var1);

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        org.jbpm.workflow.core.Node node = (org.jbpm.workflow.core.Node)parser.getCurrent();
        this.handleNode(node, element, uri, localName, parser);
        org.jbpm.workflow.core.NodeContainer nodeContainer = (org.jbpm.workflow.core.NodeContainer)parser.getParent();
        nodeContainer.addNode((Node)node);
        ((ProcessBuildData)parser.getData()).addNode(node);
        return node;
    }

    protected void handleNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        String height;
        String width;
        String y;
        String x = element.getAttribute("x");
        if (x != null && x.length() != 0) {
            try {
                node.setMetaData("x", (Object)Integer.parseInt(x));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'x' attribute", parser.getLocator());
            }
        }
        if ((y = element.getAttribute("y")) != null && y.length() != 0) {
            try {
                node.setMetaData("y", (Object)new Integer(y));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'y' attribute", parser.getLocator());
            }
        }
        if ((width = element.getAttribute("width")) != null && width.length() != 0) {
            try {
                node.setMetaData("width", (Object)new Integer(width));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'width' attribute", parser.getLocator());
            }
        }
        if ((height = element.getAttribute("height")) != null && height.length() != 0) {
            try {
                node.setMetaData("height", (Object)new Integer(height));
            }
            catch (NumberFormatException exc) {
                throw new SAXParseException("<" + localName + "> requires an Integer 'height' attribute", parser.getLocator());
            }
        }
    }

    public abstract void writeNode(org.jbpm.workflow.core.Node var1, StringBuilder var2, int var3);

    protected void writeNode(String name, org.jbpm.workflow.core.Node node, StringBuilder xmlDump, int metaDataType) {
        xmlDump.append("    <" + name + " ");
        xmlDump.append("id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)node) + "\" ");
        if (node.getName() != null) {
            xmlDump.append("name=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(node.getName()) + "\" ");
        }
        if (metaDataType == 1) {
            Integer x = (Integer)node.getMetaData().get("x");
            Integer y = (Integer)node.getMetaData().get("y");
            Integer width = (Integer)node.getMetaData().get("width");
            Integer height = (Integer)node.getMetaData().get("height");
            if (x != null && x != 0) {
                xmlDump.append("g:x=\"" + x + "\" ");
            }
            if (y != null && y != 0) {
                xmlDump.append("g:y=\"" + y + "\" ");
            }
            if (width != null && width != -1) {
                xmlDump.append("g:width=\"" + width + "\" ");
            }
            if (height != null && height != -1) {
                xmlDump.append("g:height=\"" + height + "\" ");
            }
        }
    }

    protected void endNode(StringBuilder xmlDump) {
        xmlDump.append("/>" + EOL);
    }

    protected void endNode(String name, StringBuilder xmlDump) {
        xmlDump.append("    </" + name + ">" + EOL);
    }

    protected void handleScript(ExtendedNodeImpl node, Element element, String type) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element xmlNode;
            String nodeName;
            if (!(nodeList.item(i) instanceof Element) || !(nodeName = (xmlNode = (Element)nodeList.item(i)).getNodeName()).equals("extensionElements")) continue;
            NodeList subNodeList = xmlNode.getChildNodes();
            for (int j = 0; j < subNodeList.getLength(); ++j) {
                org.w3c.dom.Node subXmlNode = subNodeList.item(j);
                if (!subXmlNode.getNodeName().contains(type + "-script")) continue;
                ArrayList<DroolsAction> actions = node.getActions(type);
                if (actions == null) {
                    actions = new ArrayList<DroolsAction>();
                    node.setActions(type, actions);
                }
                DroolsAction action = AbstractNodeHandler.extractScript((Element)subXmlNode);
                actions.add(action);
            }
        }
    }

    public static DroolsAction extractScript(Element xmlNode) {
        String dialect = "mvel";
        if ("http://www.java.com/java".equals(xmlNode.getAttribute("scriptFormat"))) {
            dialect = "java";
        } else if ("http://www.javascript.com/javascript".equals(xmlNode.getAttribute("scriptFormat"))) {
            dialect = "JavaScript";
        }
        NodeList subNodeList = xmlNode.getChildNodes();
        for (int j = 0; j < subNodeList.getLength(); ++j) {
            Element subXmlNode;
            if (!(subNodeList.item(j) instanceof Element) || !"script".equals((subXmlNode = (Element)subNodeList.item(j)).getNodeName())) continue;
            String consequence = subXmlNode.getTextContent();
            DroolsConsequenceAction action = new DroolsConsequenceAction(dialect, consequence);
            return action;
        }
        return new DroolsConsequenceAction("mvel", "");
    }

    protected void writeMetaData(org.jbpm.workflow.core.Node node, StringBuilder xmlDump) {
        XmlBPMNProcessDumper.writeMetaData(this.getMetaData(node), xmlDump);
    }

    protected Map<String, Object> getMetaData(org.jbpm.workflow.core.Node node) {
        return XmlBPMNProcessDumper.getMetaData(node.getMetaData());
    }

    protected void writeExtensionElements(org.jbpm.workflow.core.Node node, StringBuilder xmlDump) {
        if (this.containsExtensionElements(node)) {
            xmlDump.append("      <extensionElements>" + EOL);
            if (node instanceof ExtendedNodeImpl) {
                this.writeScripts("onEntry", ((ExtendedNodeImpl)node).getActions("onEntry"), xmlDump);
                this.writeScripts("onExit", ((ExtendedNodeImpl)node).getActions("onExit"), xmlDump);
            }
            this.writeMetaData(node, xmlDump);
            xmlDump.append("      </extensionElements>" + EOL);
        }
    }

    protected boolean containsExtensionElements(org.jbpm.workflow.core.Node node) {
        if (!this.getMetaData(node).isEmpty()) {
            return true;
        }
        return node instanceof ExtendedNodeImpl && ((ExtendedNodeImpl)node).containsActions();
    }

    protected void writeScripts(String type, List<DroolsAction> actions, StringBuilder xmlDump) {
        if (actions != null && actions.size() > 0) {
            for (DroolsAction action : actions) {
                AbstractNodeHandler.writeScript(action, type, xmlDump);
            }
        }
    }

    public static void writeScript(DroolsAction action, String type, StringBuilder xmlDump) {
        if (action instanceof DroolsConsequenceAction) {
            String dialect;
            DroolsConsequenceAction consequenceAction = (DroolsConsequenceAction)action;
            xmlDump.append("        <tns:" + type + "-script");
            String name = consequenceAction.getName();
            if (name != null) {
                xmlDump.append(" name=\"" + name + "\"");
            }
            if ("java".equals(dialect = consequenceAction.getDialect())) {
                xmlDump.append(" scriptFormat=\"http://www.java.com/java\"");
            } else if ("JavaScript".equals(dialect)) {
                xmlDump.append(" scriptFormat=\"http://www.javascript.com/javascript\"");
            }
            String consequence = consequenceAction.getConsequence();
            if (consequence != null) {
                xmlDump.append(">" + EOL + "          <tns:script>" + XmlDumper.replaceIllegalChars((String)consequence.trim()) + "</tns:script>" + EOL);
                xmlDump.append("        </tns:" + type + "-script>" + EOL);
            } else {
                xmlDump.append("/>" + EOL);
            }
        } else {
            throw new IllegalArgumentException("Unknown action " + action);
        }
    }

    protected void readIoSpecification(org.w3c.dom.Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                dataInputs.put(id, inputName);
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                dataOutputs.put(id, outputName);
            }
            subNode = subNode.getNextSibling();
        }
    }

    protected void readDataInputAssociation(org.w3c.dom.Node xmlNode, Map<String, String> forEachNodeInputAssociation) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String source = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            forEachNodeInputAssociation.put(target, source);
        }
    }

    protected void readDataOutputAssociation(org.w3c.dom.Node xmlNode, Map<String, String> forEachNodeOutputAssociation) {
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        if ("sourceRef".equals(subNode.getNodeName())) {
            String source = subNode.getTextContent();
            subNode = subNode.getNextSibling();
            String target = subNode.getTextContent();
            forEachNodeOutputAssociation.put(source, target);
        }
    }

    protected void readMultiInstanceLoopCharacteristics(org.w3c.dom.Node xmlNode, ForEachNode forEachNode, ExtensibleXmlParser parser) {
        for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
            String collectionName;
            Map itemDefinitions;
            DataType dataType;
            String itemSubjectRef;
            String variableName;
            String nodeName = subNode.getNodeName();
            if ("inputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("id");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                dataType = this.getDataType(itemSubjectRef, itemDefinitions, parser.getClassLoader());
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setVariable(variableName, dataType);
                continue;
            }
            if ("outputDataItem".equals(nodeName)) {
                variableName = ((Element)subNode).getAttribute("id");
                itemSubjectRef = ((Element)subNode).getAttribute("itemSubjectRef");
                dataType = null;
                itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
                dataType = this.getDataType(itemSubjectRef, itemDefinitions, parser.getClassLoader());
                if (variableName == null || variableName.trim().length() <= 0) continue;
                forEachNode.setOutputVariable(variableName, dataType);
                continue;
            }
            if ("loopDataOutputRef".equals(nodeName)) {
                String outputDataRef = ((Element)subNode).getTextContent();
                if (outputDataRef != null && outputDataRef.trim().length() > 0) {
                    collectionName = this.outputAssociation.get(outputDataRef);
                    if (collectionName == null) {
                        collectionName = this.dataOutputs.get(outputDataRef);
                    }
                    forEachNode.setOutputCollectionExpression(collectionName);
                }
                forEachNode.setMetaData("MICollectionOutput", (Object)outputDataRef);
                continue;
            }
            if ("loopDataInputRef".equals(nodeName)) {
                String inputDataRef = ((Element)subNode).getTextContent();
                if (inputDataRef != null && inputDataRef.trim().length() > 0) {
                    collectionName = this.inputAssociation.get(inputDataRef);
                    if (collectionName == null) {
                        collectionName = this.dataInputs.get(inputDataRef);
                    }
                    forEachNode.setCollectionExpression(collectionName);
                }
                forEachNode.setMetaData("MICollectionInput", (Object)inputDataRef);
                continue;
            }
            if (!"completionCondition".equals(nodeName)) continue;
            String expression = subNode.getTextContent();
            forEachNode.setCompletionConditionExpression(expression);
        }
    }

    protected DataType getDataType(String itemSubjectRef, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        Object dataType = new ObjectDataType();
        if (itemDefinitions == null) {
            return dataType;
        }
        ItemDefinition itemDefinition = itemDefinitions.get(itemSubjectRef);
        if (itemDefinition != null) {
            String structureRef = itemDefinition.getStructureRef();
            dataType = "java.lang.Boolean".equals(structureRef) || "Boolean".equals(structureRef) ? new BooleanDataType() : ("java.lang.Integer".equals(structureRef) || "Integer".equals(structureRef) ? new IntegerDataType() : ("java.lang.Float".equals(structureRef) || "Float".equals(structureRef) ? new FloatDataType() : ("java.lang.String".equals(structureRef) || "String".equals(structureRef) ? new StringDataType() : ("java.lang.Object".equals(structureRef) || "Object".equals(structureRef) ? new ObjectDataType(structureRef) : new ObjectDataType(structureRef, cl)))));
        }
        return dataType;
    }

    protected String getErrorIdForErrorCode(String errorCode, org.jbpm.workflow.core.Node node) {
        NodeContainer parent = node.getNodeContainer();
        while (!(parent instanceof RuleFlowProcess) && parent instanceof org.jbpm.workflow.core.Node) {
            parent = ((org.jbpm.workflow.core.Node)parent).getNodeContainer();
        }
        if (!(parent instanceof RuleFlowProcess)) {
            throw new RuntimeException("This should never happen: !(parent instanceof RuleFlowProcess): parent is " + parent.getClass().getSimpleName());
        }
        List<Error> errors = ((Definitions)((RuleFlowProcess)parent).getMetaData("Definitions")).getErrors();
        Signal error = null;
        for (Error listError : errors) {
            if (errorCode.equals(listError.getErrorCode())) {
                error = listError;
                break;
            }
            if (!errorCode.equals(listError.getId())) continue;
            error = listError;
            break;
        }
        if (error == null) {
            throw new IllegalArgumentException("Could not find error with errorCode " + errorCode);
        }
        return error.getId();
    }

    protected void handleThrowCompensationEventNode(org.jbpm.workflow.core.Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) {
        assert (node instanceof ActionNode || node instanceof EndNode) : "Node is neither an ActionNode nor an EndNode but a " + node.getClass().getSimpleName();
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            if (!"compensateEventDefinition".equals(xmlNode.getNodeName())) continue;
            String activityRef = ((Element)xmlNode).getAttribute("activityRef");
            if (activityRef == null) {
                activityRef = "";
            }
            node.setMetaData("compensation-activityRef", (Object)activityRef);
            String nodeId = (String)node.getMetaData().get("UniqueId");
            String waitForCompletionString = ((Element)xmlNode).getAttribute("waitForCompletion");
            boolean waitForCompletion = true;
            if (waitForCompletionString != null && waitForCompletionString.length() > 0) {
                waitForCompletion = Boolean.parseBoolean(waitForCompletionString);
            }
            if (waitForCompletion) continue;
            throw new IllegalArgumentException("Asynchronous compensation [" + nodeId + ", " + node.getName() + "] is not yet supported!");
        }
    }

    protected void writeVariableName(EventNode eventNode, StringBuilder xmlDump) {
        if (eventNode.getVariableName() != null) {
            xmlDump.append("      <dataOutput id=\"" + XmlBPMNProcessDumper.getUniqueNodeId((Node)eventNode) + "_Output\" name=\"event\" />" + EOL);
            xmlDump.append("      <dataOutputAssociation>" + EOL);
            xmlDump.append("      <sourceRef>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)eventNode) + "_Output</sourceRef>" + EOL + "      <targetRef>" + XmlDumper.replaceIllegalChars((String)eventNode.getVariableName()) + "</targetRef>" + EOL);
            xmlDump.append("      </dataOutputAssociation>" + EOL);
            xmlDump.append("      <outputSet>" + EOL);
            xmlDump.append("        <dataOutputRefs>" + XmlBPMNProcessDumper.getUniqueNodeId((Node)eventNode) + "_Output</dataOutputRefs>" + EOL);
            xmlDump.append("      </outputSet>" + EOL);
        }
    }

    protected String getSignalExpression(NodeImpl node, String signalName, String variable) {
        String signalExpression = RUNTIME_SIGNAL_EVENT;
        String scope = (String)node.getMetaData("customScope");
        signalExpression = "processInstance".equalsIgnoreCase(scope) ? "kcontext.getProcessInstance().signalEvent(org.jbpm.process.instance.impl.util.VariableUtil.resolveVariable(\"" + signalName + "\", kcontext.getNodeInstance()), " + (variable == null ? "null" : variable) + ");" : ("runtimeManager".equalsIgnoreCase(scope) || "project".equalsIgnoreCase(scope) ? "((org.kie.api.runtime.manager.RuntimeManager)kcontext.getKnowledgeRuntime().getEnvironment().get(\"RuntimeManager\")).signalEvent(org.jbpm.process.instance.impl.util.VariableUtil.resolveVariable(\"" + signalName + "\", kcontext.getNodeInstance()), " + (variable == null ? "null" : variable) + ");" : ("external".equalsIgnoreCase(scope) ? "org.drools.core.process.instance.impl.WorkItemImpl workItem = new org.drools.core.process.instance.impl.WorkItemImpl();" + EOL + "workItem.setName(\"External Send Task\");" + EOL + "workItem.setNodeInstanceId(kcontext.getNodeInstance().getId());" + EOL + "workItem.setProcessInstanceId(kcontext.getProcessInstance().getId());" + EOL + "workItem.setNodeId(kcontext.getNodeInstance().getNodeId());" + EOL + "workItem.setDeploymentId((String) kcontext.getKnowledgeRuntime().getEnvironment().get(\"deploymentId\"));" + EOL + "workItem.setParameter(\"Signal\", org.jbpm.process.instance.impl.util.VariableUtil.resolveVariable(\"" + signalName + "\", kcontext.getNodeInstance()));" + EOL + "workItem.setParameter(\"SignalProcessInstanceId\", kcontext.getVariable(\"SignalProcessInstanceId\"));" + EOL + "workItem.setParameter(\"SignalWorkItemId\", kcontext.getVariable(\"SignalWorkItemId\"));" + EOL + "workItem.setParameter(\"SignalDeploymentId\", kcontext.getVariable(\"SignalDeploymentId\"));" + EOL + (variable == null ? "" : "workItem.setParameter(\"Data\", " + variable + ");" + EOL) + "((org.drools.core.process.instance.WorkItemManager) kcontext.getKnowledgeRuntime().getWorkItemManager()).internalExecuteWorkItem(workItem);" : signalExpression + "org.jbpm.process.instance.impl.util.VariableUtil.resolveVariable(\"" + signalName + "\", kcontext.getNodeInstance()), " + (variable == null ? "null" : variable) + ");"));
        return signalExpression;
    }
}

