/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ruleflow.core.factory;

import org.drools.core.process.core.datatype.DataType;
import org.jbpm.process.core.context.exception.ActionExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.exception.ExceptionScope;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.ruleflow.core.RuleFlowNodeContainerFactory;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.CompositeContextNode;

public class CompositeNodeFactory
extends RuleFlowNodeContainerFactory {
    private RuleFlowNodeContainerFactory nodeContainerFactory;
    private NodeContainer nodeContainer;
    private long linkedIncomingNodeId = -1L;
    private long linkedOutgoingNodeId = -1L;

    public CompositeNodeFactory(RuleFlowNodeContainerFactory nodeContainerFactory, NodeContainer nodeContainer, long id) {
        this.nodeContainerFactory = nodeContainerFactory;
        this.nodeContainer = nodeContainer;
        CompositeContextNode compositeNode = new CompositeContextNode();
        compositeNode.setId(id);
        this.setNodeContainer(compositeNode);
    }

    protected CompositeContextNode getCompositeNode() {
        return (CompositeContextNode)this.getNodeContainer();
    }

    public CompositeNodeFactory name(String name) {
        this.getCompositeNode().setName(name);
        return this;
    }

    public CompositeNodeFactory variable(String name, DataType type) {
        return this.variable(name, type, null);
    }

    public CompositeNodeFactory variable(String name, DataType type, Object value) {
        Variable variable = new Variable();
        variable.setName(name);
        variable.setType(type);
        variable.setValue(value);
        VariableScope variableScope = (VariableScope)this.getCompositeNode().getDefaultContext("VariableScope");
        if (variableScope == null) {
            variableScope = new VariableScope();
            this.getCompositeNode().addContext(variableScope);
            this.getCompositeNode().setDefaultContext(variableScope);
        }
        variableScope.getVariables().add(variable);
        return this;
    }

    public CompositeNodeFactory exceptionHandler(String exception, ExceptionHandler exceptionHandler) {
        ExceptionScope exceptionScope = (ExceptionScope)this.getCompositeNode().getDefaultContext("ExceptionScope");
        if (exceptionScope == null) {
            exceptionScope = new ExceptionScope();
            this.getCompositeNode().addContext(exceptionScope);
            this.getCompositeNode().setDefaultContext(exceptionScope);
        }
        exceptionScope.setExceptionHandler(exception, exceptionHandler);
        return this;
    }

    public CompositeNodeFactory exceptionHandler(String exception, String dialect, String action) {
        ActionExceptionHandler exceptionHandler = new ActionExceptionHandler();
        exceptionHandler.setAction(new DroolsConsequenceAction(dialect, action));
        return this.exceptionHandler(exception, exceptionHandler);
    }

    public CompositeNodeFactory linkIncomingConnections(long nodeId) {
        this.linkedIncomingNodeId = nodeId;
        return this;
    }

    public CompositeNodeFactory linkOutgoingConnections(long nodeId) {
        this.linkedOutgoingNodeId = nodeId;
        return this;
    }

    @Override
    public RuleFlowNodeContainerFactory done() {
        if (this.linkedIncomingNodeId != -1L) {
            this.getCompositeNode().linkIncomingConnections("DROOLS_DEFAULT", this.linkedIncomingNodeId, "DROOLS_DEFAULT");
        }
        if (this.linkedOutgoingNodeId != -1L) {
            this.getCompositeNode().linkOutgoingConnections(this.linkedOutgoingNodeId, "DROOLS_DEFAULT", "DROOLS_DEFAULT");
        }
        this.nodeContainer.addNode(this.getCompositeNode());
        return this.nodeContainerFactory;
    }
}

