/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.audit.jms;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.variable.ProcessIndexerManager;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAuditLogProducer
extends AbstractAuditLogger {
    private static final Logger logger = LoggerFactory.getLogger(AsyncAuditLogProducer.class);
    private ConnectionFactory connectionFactory;
    private Queue queue;
    private boolean transacted = true;
    private ProcessIndexerManager indexManager = ProcessIndexerManager.get();

    public AsyncAuditLogProducer() {
    }

    public AsyncAuditLogProducer(KieSession session, boolean transacted) {
        super(session);
        this.transacted = transacted;
        session.addEventListener((ProcessEventListener)this);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Queue getQueue() {
        return this.queue;
    }

    public void setQueue(Queue queue) {
        this.queue = queue;
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.builder.buildEvent(event);
        this.sendMessage(log, 4);
        ((NodeInstanceImpl)event.getNodeInstance()).getMetaData().put("NodeInstanceLog", log);
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)this.builder.buildEvent(event, null);
        this.sendMessage(log, 7);
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        List<VariableInstanceLog> variables = this.indexManager.index(this.getBuilder(), event);
        for (VariableInstanceLog log : variables) {
            this.sendMessage(log, 9);
        }
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent(event);
        this.sendMessage(log, 0);
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        ProcessInstanceLog log = (ProcessInstanceLog)this.builder.buildEvent(event, null);
        this.sendMessage(log, 3);
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        NodeInstanceLog log = (NodeInstanceLog)((NodeInstanceImpl)event.getNodeInstance()).getMetaData().get("NodeInstanceLog");
        NodeInstanceLog logUpdated = (NodeInstanceLog)this.builder.buildEvent(event, (Object)log);
        if (logUpdated != null) {
            this.sendMessage(log, 5);
        }
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    protected void sendMessage(Object messageContent, Integer eventType) {
        if (this.connectionFactory == null && this.queue == null) {
            throw new IllegalStateException("ConnectionFactory and Queue cannot be null");
        }
        Connection queueConnection = null;
        Session queueSession = null;
        MessageProducer producer = null;
        try {
            queueConnection = this.connectionFactory.createConnection();
            queueSession = queueConnection.createSession(this.transacted, 1);
            XStream xstream = new XStream();
            String eventXml = xstream.toXML(messageContent);
            TextMessage message = queueSession.createTextMessage(eventXml);
            message.setIntProperty("EventType", eventType.intValue());
            producer = queueSession.createProducer((Destination)this.queue);
            producer.send((Message)message);
        }
        catch (Exception e) {
            throw new RuntimeException("Error when sending JMS message with working memory event", e);
        }
        finally {
            if (producer != null) {
                try {
                    producer.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing producer", (Throwable)e);
                }
            }
            if (queueSession != null) {
                try {
                    queueSession.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue session", (Throwable)e);
                }
            }
            if (queueConnection != null) {
                try {
                    queueConnection.close();
                }
                catch (JMSException e) {
                    logger.warn("Error when closing queue connection", (Throwable)e);
                }
            }
        }
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }
}

