/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.guvnor.tools.Activator;
import org.guvnor.tools.GuvnorLocationManager;
import org.guvnor.tools.GuvnorRepository;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.PlatformUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavClientFactory;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.views.RepositoryContentProvider;
import org.guvnor.tools.views.RepositoryLabelProvider;
import org.guvnor.tools.views.model.TreeObject;
import org.guvnor.tools.views.model.TreeParent;
import org.guvnor.tools.wizards.NewRepLocationWizard;

public class RepositoryView
extends ViewPart {
    private TreeViewer viewer;
    private DrillDownAdapter drillDownAdapter;
    private Action deleteRepositoryLocAction;
    private Action addRepositoryLocAction;
    private Action doubleClickAction;
    private Action refreshAction;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoryLabelProvider());
        this.viewer.setSorter((ViewerSorter)new NameSorter());
        this.viewer.setInput((Object)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        Activator.getLocationManager().addRepositorySetListener(new GuvnorLocationManager.IRepositorySetListener(){

            @Override
            public void repositorySetChanged(int type, List<GuvnorRepository> repList) {
                RepositoryView.this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
            }
        });
        super.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.addDragDropSupport();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    private void addDragDropSupport() {
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        this.viewer.addDragSupport(1, transfers, new DragSourceListener(){
            private TreeObject[] target;

            public void dragFinished(DragSourceEvent event) {
                this.target = null;
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                if (this.target == null) {
                    return;
                }
                try {
                    List files = RepositoryView.this.prepareFileTransfer(this.target);
                    String[] res = new String[files.size()];
                    files.toArray(res);
                    event.data = res;
                }
                catch (Exception e) {
                    Activator.getDefault().displayError(4, e.getMessage(), e, true);
                }
            }

            public void dragStart(DragSourceEvent event) {
                ArrayList<TreeObject> transferNodes = new ArrayList<TreeObject>();
                ISelection selection = RepositoryView.this.viewer.getSelection();
                Object[] objs = ((IStructuredSelection)selection).toArray();
                int i = 0;
                while (i < objs.length) {
                    if (objs[i] instanceof TreeObject && ((TreeObject)objs[i]).getNodeType() == TreeObject.Type.RESOURCE) {
                        transferNodes.add((TreeObject)objs[i]);
                    }
                    ++i;
                }
                if (transferNodes.size() > 0) {
                    event.doit = true;
                    this.target = new TreeObject[transferNodes.size()];
                    transferNodes.toArray(this.target);
                } else {
                    event.doit = false;
                }
            }
        });
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){
            private TreeParent targetNode;

            public boolean performDrop(Object data) {
                if (this.targetNode == null) {
                    return false;
                }
                String[] items = (String[])data;
                boolean isvalid = RepositoryView.this.validateInputResource(items);
                if (!isvalid) {
                    return false;
                }
                String[] errors = RepositoryView.this.processDrop(this.targetNode, items);
                if (errors.length != 0) {
                    StringBuilder msg = new StringBuilder();
                    int i = 0;
                    while (i < errors.length) {
                        msg.append(errors[i]);
                        msg.append("\r\n");
                        ++i;
                    }
                    Activator.getDefault().displayError(4, msg.toString(), new Exception(), true);
                }
                if (items.length != errors.length) {
                    PlatformUtils.updateDecoration();
                    PlatformUtils.refreshRepositoryView();
                }
                return items.length != errors.length;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null || !(target instanceof TreeParent)) {
                    this.targetNode = null;
                    return false;
                }
                this.targetNode = (TreeParent)target;
                return true;
            }
        });
    }

    private boolean validateInputResource(String[] filenames) {
        String[] stringArray = filenames;
        int n = filenames.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            File file = new File(filename);
            String msg = "";
            if (!file.isFile()) {
                msg = MessageFormat.format(Messages.getString("error.message.isfolder"), filename);
                MessageDialog.openError(null, (String)"Problem Occurred", (String)msg);
                return false;
            }
            String name = file.getName();
            if (name.indexOf(".") <= 0) {
                msg = MessageFormat.format(Messages.getString("error.message.invalid.filename"), filename);
                MessageDialog.openError(null, (String)"Problem Occurred", (String)msg);
                return false;
            }
            ++n2;
        }
        return true;
    }

    private String[] processDrop(TreeParent target, String[] items) {
        ArrayList<String> errors = new ArrayList<String>();
        int i = 0;
        while (i < items.length) {
            block9: {
                IFile sourceFile = PlatformUtils.getResourceFromFSPath(items[i]);
                if (sourceFile != null) {
                    try {
                        GuvnorMetadataProps md = GuvnorMetadataUtils.getGuvnorMetadata((IResource)sourceFile);
                        if (md == null) {
                            boolean res = GuvnorMetadataUtils.addResourceToGuvnor(target.getGuvnorRepository().getLocation(), target.getFullPath(), sourceFile);
                            if (!res) {
                                errors.add(MessageFormat.format(Messages.getString("add.failure.exist"), sourceFile.getName(), target.getFullPath()));
                            }
                            break block9;
                        }
                        String itemPath = String.valueOf(target.getFullPath()) + sourceFile.getName();
                        if (itemPath.equals(md.getFullpath())) {
                            if (!GuvnorMetadataUtils.isGuvnorResourceCurrent((IResource)sourceFile)) {
                                GuvnorMetadataUtils.commitFileChanges(sourceFile);
                            }
                            break block9;
                        }
                        errors.add(MessageFormat.format(Messages.getString("already.guvnor.as"), items[i], md.getFullpath()));
                    }
                    catch (Exception e) {
                        Activator.getDefault().writeLog(4, e.getMessage(), e);
                    }
                } else {
                    Activator.getDefault().writeLog(2, "Could not resolve: " + items[i], new Exception());
                }
            }
            ++i;
        }
        String[] res = new String[errors.size()];
        errors.toArray(res);
        return res;
    }

    private List<String> prepareFileTransfer(TreeObject[] nodes) throws Exception {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < nodes.length) {
            String contents = this.getResourceContents(nodes[i]);
            Path path = new Path(String.valueOf(Activator.getDefault().getStateLocation().toOSString()) + File.separator + "t" + String.valueOf(System.currentTimeMillis()));
            if (!path.toFile().mkdir()) {
                throw new Exception("Could not create directory " + path.toOSString());
            }
            path.toFile().deleteOnExit();
            File transfer = new File(path + File.separator + nodes[i].getName());
            transfer.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(transfer);
            PrintWriter writer = new PrintWriter(fos);
            writer.write(contents);
            writer.flush();
            writer.close();
            res.add(transfer.getAbsolutePath());
            IPath metaPath = GuvnorMetadataUtils.createGuvnorMetadataLocation(path.toOSString());
            metaPath.toFile().deleteOnExit();
            File metaFile = GuvnorMetadataUtils.getGuvnorMetadataFile(metaPath.toOSString(), nodes[i].getName());
            metaFile.deleteOnExit();
            GuvnorMetadataUtils.writeGuvnorMetadataProps(metaFile, this.getGuvnorMetadataProps(nodes[i]));
            res.add(metaFile.getAbsolutePath());
            Thread.sleep(1L, 0);
            ++i;
        }
        return res;
    }

    private GuvnorMetadataProps getGuvnorMetadataProps(TreeObject node) throws Exception {
        GuvnorRepository rep = node.getGuvnorRepository();
        IWebDavClient webdav = WebDavServerCache.getWebDavClient(rep.getLocation());
        if (webdav == null) {
            webdav = WebDavClientFactory.createClient(new URL(rep.getLocation()));
            WebDavServerCache.cacheWebDavClient(rep.getLocation(), webdav);
        }
        ResourceProperties props = webdav.queryProperties(node.getFullPath());
        return new GuvnorMetadataProps(node.getName(), node.getGuvnorRepository().getLocation(), node.getFullPath(), props.getLastModifiedDate(), props.getRevision());
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RepositoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.deleteRepositoryLocAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.addRepositoryLocAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
    }

    private boolean shouldAddDeleteAction() {
        ISelection selection = this.viewer.getSelection();
        if (selection == null) {
            return false;
        }
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        if (obj instanceof TreeParent) {
            return ((TreeParent)obj).getNodeType() == TreeObject.Type.REPOSITORY;
        }
        return false;
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.shouldAddDeleteAction()) {
            manager.add((IAction)this.deleteRepositoryLocAction);
        }
        manager.add((IAction)this.refreshAction);
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.deleteRepositoryLocAction);
        manager.add((IAction)this.addRepositoryLocAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.deleteRepositoryLocAction = new Action(){

            public void run() {
                ISelection selection = RepositoryView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TreeParent) {
                    GuvnorRepository rep = ((TreeParent)obj).getGuvnorRepository();
                    if (MessageDialog.openConfirm((Shell)RepositoryView.this.getSite().getShell(), (String)Messages.getString("remove.rep.dialog.caption"), (String)MessageFormat.format(Messages.getString("remove.rep.dialog.msg"), rep.getLocation()))) {
                        Activator.getLocationManager().removeRepository(rep.getLocation());
                    }
                }
            }
        };
        this.deleteRepositoryLocAction.setText(Messages.getString("action.delete.rep"));
        this.deleteRepositoryLocAction.setToolTipText(Messages.getString("action.delete.rep.desc"));
        this.deleteRepositoryLocAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.addRepositoryLocAction = new Action(){

            public void run() {
                NewRepLocationWizard wiz = new NewRepLocationWizard();
                wiz.init(Activator.getDefault().getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(RepositoryView.this.getSite().getShell(), (IWizard)wiz);
                dialog.create();
                dialog.open();
            }
        };
        this.addRepositoryLocAction.setText(Messages.getString("action.add.rep"));
        this.addRepositoryLocAction.setToolTipText(Messages.getString("action.add.rep.desc"));
        this.addRepositoryLocAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = RepositoryView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof TreeObject) {
                    RepositoryView.this.doubleClick((TreeObject)obj);
                }
            }
        };
        this.refreshAction = new Action(){

            public void run() {
                IStructuredSelection strucSel;
                ISelection selection = RepositoryView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && !(strucSel = (IStructuredSelection)selection).isEmpty()) {
                    RepositoryView.this.viewer.refresh(strucSel.getFirstElement());
                }
            }
        };
        this.refreshAction.setText(Messages.getString("action.refresh.rep"));
        this.refreshAction.setToolTipText(Messages.getString("action.refresh.rep.desc"));
        this.refreshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_REDO"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositoryView.this.doubleClickAction.run();
            }
        });
    }

    private void doubleClick(TreeObject node) {
        if (node instanceof TreeParent) {
            if (this.viewer.getExpandedState((Object)node)) {
                this.viewer.collapseToLevel((Object)node, 1);
            } else {
                this.viewer.expandToLevel((Object)node, 1);
            }
        } else {
            try {
                String contents = this.getResourceContents(node);
                PlatformUtils.openEditor(contents, node.getName());
            }
            catch (Exception e) {
                Activator.getDefault().displayError(4, e.getMessage(), e, true);
            }
        }
    }

    private String getResourceContents(TreeObject node) throws Exception {
        GuvnorRepository rep = node.getGuvnorRepository();
        IWebDavClient webdav = WebDavServerCache.getWebDavClient(rep.getLocation());
        if (webdav == null) {
            webdav = WebDavClientFactory.createClient(new URL(rep.getLocation()));
            WebDavServerCache.cacheWebDavClient(rep.getLocation(), webdav);
        }
        String res = webdav.getResourceContents(node.getFullPath());
        return res;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }
}

