/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.preferences;

import java.io.File;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.core.IServer;
import org.kie.eclipse.navigator.preferences.AbstractKiePropertyPage;
import org.kie.eclipse.navigator.preferences.PasswordFieldEditor;
import org.kie.eclipse.navigator.preferences.ReadonlyStringFieldEditor;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.KieServerHandler;

public class ServerPropertyPage
extends AbstractKiePropertyPage {
    private MyDirectoryFieldEditor gitPathEditor;
    private BooleanFieldEditor useDefaultGitPathEditor;

    public ServerPropertyPage() {
        super(1);
    }

    @Override
    protected void createFieldEditors() {
        IServer server = this.getResourceHandler().getServer();
        this.addField(new ReadonlyStringFieldEditor("Server Name:", server.getName(), this.getFieldEditorParent()));
        this.addField(new ReadonlyStringFieldEditor("Host Name:", server.getHost(), this.getFieldEditorParent()));
        StringFieldEditor stringEditor = new StringFieldEditor("ServerUsername", "Username:", this.getFieldEditorParent());
        this.addField((FieldEditor)stringEditor);
        PasswordFieldEditor passwordEditor = new PasswordFieldEditor("ServerPassword", "Password:", this.getFieldEditorParent());
        this.addField(passwordEditor);
        MessageDialogToggleFieldEditor boolEditor = new MessageDialogToggleFieldEditor("ServerTrustedConnection", "Trust connections to this Server", this.getFieldEditorParent());
        this.addField((FieldEditor)boolEditor);
        stringEditor = new StringFieldEditor("ServerKieApplicationName", "KIE Application Name:", this.getFieldEditorParent());
        this.addField((FieldEditor)stringEditor);
        IntegerFieldEditor intEditor = new IntegerFieldEditor("ServerHttpPort", "HTTP Port:", this.getFieldEditorParent());
        this.addField((FieldEditor)intEditor);
        intEditor = new IntegerFieldEditor("ServerGitPort", "Git Port:", this.getFieldEditorParent());
        this.addField((FieldEditor)intEditor);
        this.useDefaultGitPathEditor = new BooleanFieldEditor("UseDefaultGitPath", "Use default Git Repository Path", this.getFieldEditorParent());
        this.addField((FieldEditor)this.useDefaultGitPathEditor);
        this.gitPathEditor = new MyDirectoryFieldEditor("RepositoryPath", "Git Repository Path", this.getFieldEditorParent());
        this.gitPathEditor.setErrorMessage("Git Repository Path must be an existing directory");
        this.addField((FieldEditor)this.gitPathEditor);
    }

    private void updateControls() {
        this.setErrorMessage(null);
        Button checkBox = (Button)this.useDefaultGitPathEditor.getDescriptionControl(this.getFieldEditorParent());
        boolean checked = checkBox.getSelection();
        this.gitPathEditor.setEnabled(!checked, this.getFieldEditorParent());
        this.gitPathEditor.setEmptyStringAllowed(checked);
        if (!checked && this.gitPathEditor.getStringValue().isEmpty()) {
            String defaultRepoPath = UIUtils.getDefaultRepositoryDir();
            String repoPath = this.getResourceHandler().getPreferenceName(null).replace("|".charAt(0), File.separator.charAt(0));
            defaultRepoPath = defaultRepoPath != null ? String.valueOf(defaultRepoPath) + File.separator + repoPath : String.valueOf(File.separator) + repoPath;
            this.gitPathEditor.setStringValue(defaultRepoPath);
        }
        this.gitPathEditor.refreshValidState();
        this.checkState();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.updateControls();
        Button checkBox = (Button)this.useDefaultGitPathEditor.getDescriptionControl(this.getFieldEditorParent());
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ServerPropertyPage.this.updateControls();
            }
        });
    }

    @Override
    protected Class<? extends IKieResourceHandler> getResourceHandlerType() {
        return KieServerHandler.class;
    }

    private static class MessageDialogToggleFieldEditor
    extends BooleanFieldEditor {
        private Composite parent;

        public MessageDialogToggleFieldEditor(String name, String label, Composite parent) {
            super(name, label, parent);
            this.parent = parent;
        }

        protected void doLoad() {
            Button checkBox = this.getChangeControl(this.parent);
            if (checkBox != null) {
                String value = this.getPreferenceStore().getString(this.getPreferenceName());
                checkBox.setSelection("always".equals(value));
            }
        }

        protected void doLoadDefault() {
            Button checkBox = this.getChangeControl(this.parent);
            if (checkBox != null) {
                String value = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
                checkBox.setSelection("always".equals(value));
            }
        }

        protected void doStore() {
            Button checkBox = this.getChangeControl(this.parent);
            this.getPreferenceStore().setValue(this.getPreferenceName(), checkBox.getSelection() ? "always" : "never");
        }
    }

    private class MyDirectoryFieldEditor
    extends DirectoryFieldEditor {
        public MyDirectoryFieldEditor(String prefGitRepoPath, String string, Composite fieldEditorParent) {
            super(prefGitRepoPath, string, fieldEditorParent);
        }

        protected void createControl(Composite parent) {
            this.setValidateStrategy(0);
            super.createControl(parent);
        }

        public void refreshValidState() {
            super.refreshValidState();
        }

        protected boolean checkState() {
            if (ServerPropertyPage.this.useDefaultGitPathEditor.getBooleanValue()) {
                return true;
            }
            return super.checkState();
        }
    }
}

