/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.CompositeNode;
import org.kie.api.definition.process.Connection;

public abstract class AbstractCompositeNodeHandler
extends AbstractNodeHandler {
    protected void visitConnectionsAndAssociations(Node node, StringBuilder xmlDump, int metaDataType) {
        List<Connection> connections = this.getSubConnections((CompositeNode)node);
        xmlDump.append("    <!-- connections -->" + EOL);
        for (Connection connection : connections) {
            XmlBPMNProcessDumper.INSTANCE.visitConnection(connection, xmlDump, metaDataType);
        }
        List associations = (List)node.getMetaData().get("BPMN.Associations");
        if (associations != null) {
            for (Association association : associations) {
                XmlBPMNProcessDumper.INSTANCE.visitAssociation(association, xmlDump);
            }
        }
    }

    protected List<Connection> getSubConnections(CompositeNode compositeNode) {
        ArrayList<Connection> connections = new ArrayList<Connection>();
        for (org.kie.api.definition.process.Node subNode : compositeNode.getNodes()) {
            if (subNode instanceof CompositeNode.CompositeNodeEnd) continue;
            for (Connection connection : subNode.getIncomingConnections("DROOLS_DEFAULT")) {
                if (connection.getFrom() instanceof CompositeNode.CompositeNodeStart) continue;
                connections.add(connection);
            }
        }
        return connections;
    }
}

