/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.debug.core;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.drools.eclipse.DRLInfo;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.debug.DebugUtil;
import org.drools.eclipse.debug.VariableWrapper;
import org.drools.eclipse.debug.core.DroolsDebugTarget;
import org.drools.eclipse.debug.core.DroolsLineBreakpoint;
import org.drools.eclipse.debug.core.DroolsStackFrame;
import org.drools.eclipse.debug.core.DroolsThread;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdt.debug.core.IJavaClassObject;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.internal.debug.core.model.JDILocalVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;

public class MVELStackFrame
extends DroolsStackFrame {
    private final MVELStackFrameContext ctxCache = new MVELStackFrameContext();
    private static final IJavaReferenceType REF_TYPE = new IJavaReferenceType(){

        public IJavaFieldVariable getField(String name) throws DebugException {
            return null;
        }

        public IJavaClassObject getClassObject() throws DebugException {
            return null;
        }

        public String[] getAvailableStrata() throws DebugException {
            return null;
        }

        public String getDefaultStratum() throws DebugException {
            return "MVEL";
        }

        public String[] getDeclaredFieldNames() throws DebugException {
            return null;
        }

        public String[] getAllFieldNames() throws DebugException {
            return null;
        }

        public IJavaObject getClassLoaderObject() throws DebugException {
            return null;
        }

        public String getGenericSignature() throws DebugException {
            return null;
        }

        public String getSourceName() throws DebugException {
            return null;
        }

        public String[] getSourceNames(String stratum) throws DebugException {
            return null;
        }

        public String[] getSourcePaths(String stratum) throws DebugException {
            return null;
        }

        public IJavaObject[] getInstances(long max) throws DebugException {
            return null;
        }

        public String getName() throws DebugException {
            return null;
        }

        public String getSignature() throws DebugException {
            return null;
        }

        public IDebugTarget getDebugTarget() {
            return null;
        }

        public ILaunch getLaunch() {
            return null;
        }

        public String getModelIdentifier() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public long getInstanceCount() throws DebugException {
            return 0L;
        }
    };

    public MVELStackFrame(DroolsThread thread, StackFrame frame, int depth) {
        super(thread, frame, depth);
    }

    @Override
    public DRLInfo.RuleInfo getExecutingRuleInfo() {
        try {
            String type = this.getDeclaringTypeName();
            return DroolsEclipsePlugin.getDefault().getRuleInfoByClass(type);
        }
        catch (DebugException exc) {
            DroolsEclipsePlugin.log(exc);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVariable[] getVariables() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            if (!this.isSuspended()) {
                return new IVariable[0];
            }
            IVariable[] cache = this.ctxCache.getCacheVariables();
            if (cache != null) {
                return cache;
            }
            ArrayList<VariableWrapper> result = new ArrayList<VariableWrapper>(0);
            Method method = this.getUnderlyingMethod();
            method.declaringType();
            try {
                LocalVariable var;
                LocalVariable v2 = var = method.variables().get(0);
                JDILocalVariable frameLocal = new JDILocalVariable((JDIStackFrame)this, v2);
                IValue knownVars = DebugUtil.getValueByExpression("return getFactory().getKnownVariables().toArray(new String[0]);", frameLocal.getValue());
                JDIObjectValue vvv = (JDIObjectValue)knownVars;
                if (vvv != null && ((ArrayReference)vvv.getUnderlyingObject()).length() > 0) {
                    ArrayReference arr = (ArrayReference)vvv.getUnderlyingObject();
                    Iterator<Value> varIter = arr.getValues().iterator();
                    while (varIter.hasNext()) {
                        String varName = ((StringReference)varIter.next()).value();
                        IJavaValue val = (IJavaValue)DebugUtil.getValueByExpression("return getFactory().getVariableResolver(\"" + varName + "\").getValue();", frameLocal.getValue());
                        if (val != null) {
                            ((JDIObjectValue)val).getUnderlyingObject();
                            VariableWrapper local = new VariableWrapper(varName, val);
                            local.setPublic(true);
                            result.add(local);
                            continue;
                        }
                        DroolsEclipsePlugin.log(new Exception("Unable to get value for variable named '" + varName + "' suspend=" + this.isSuspended()));
                    }
                }
                IVariable[] vararr = result.toArray(new IVariable[result.size()]);
                Arrays.sort(vararr, new Comparator<IVariable>(){

                    @Override
                    public int compare(IVariable var1, IVariable var2) {
                        try {
                            return var1.getName().compareTo(var2.getName());
                        }
                        catch (DebugException debugException) {
                            return 0;
                        }
                    }
                });
                result = new ArrayList((vararr.length - 1) / 2);
                int i = 0;
                while (i < vararr.length) {
                    String name = vararr[i].getName();
                    if (!name.equals("drools") && !name.endsWith("__Handle__")) {
                        result.add((VariableWrapper)vararr[i]);
                    }
                    ++i;
                }
                vararr = result.toArray(new IVariable[result.size()]);
                this.ctxCache.setCacheVariables(vararr);
                return vararr;
            }
            catch (Throwable t) {
                DroolsEclipsePlugin.log(t);
                return new IVariable[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineNumber() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            int res;
            block10: {
                int line;
                DroolsLineBreakpoint bpoint;
                String sourceName;
                block9: {
                    int cache = this.ctxCache.getCacheLineNumber();
                    if (cache != -1) {
                        return cache;
                    }
                    DroolsDebugTarget t = (DroolsDebugTarget)this.getDebugTarget();
                    bpoint = t.getDroolsBreakpoint(sourceName = this.getMVELName());
                    if (bpoint != null) break block9;
                    return -1;
                }
                try {
                    line = Integer.parseInt(bpoint.getFileRuleMappings().get(sourceName).toString());
                }
                catch (Throwable t2) {
                    DroolsEclipsePlugin.log(t2);
                    return -1;
                }
                int fragmentLine = this.getBreakpointLineNumber();
                res = line + fragmentLine;
                if (fragmentLine != -1) break block10;
                return -1;
            }
            this.ctxCache.setCacheLineNumber(res);
            return res;
        }
    }

    private int getBreakpointLineNumber() {
        Object o;
        block13: {
            block12: {
                block10: {
                    if (this.ctxCache.getCacheBreakpointLineNumber() != -1) {
                        return this.ctxCache.getCacheBreakpointLineNumber();
                    }
                    o = this.getRemoteVar("lineNumber");
                    if (o != null) break block10;
                    return -1;
                }
                try {
                    IntegerValue val = (IntegerValue)o;
                    int realval = val.value();
                    this.ctxCache.setCacheBreakpointLineNumber(realval);
                    return realval;
                }
                catch (NullPointerException nullPointerException) {
                }
                catch (Throwable e) {
                    DroolsEclipsePlugin.log(e);
                }
                o = this.getRemoteVar("label");
                if (o != null) break block12;
                return -1;
            }
            ObjectReference obj = (ObjectReference)o;
            ClassType frameType = (ClassType)obj.type();
            Field field = frameType.fieldByName("lineNumber");
            o = obj.getValue(field);
            if (o != null) break block13;
            return -1;
        }
        try {
            IntegerValue val = (IntegerValue)o;
            int realval = val.value();
            this.ctxCache.setCacheBreakpointLineNumber(realval);
            return realval;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Throwable e) {
            DroolsEclipsePlugin.log(e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMVELName() {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            String cache = this.ctxCache.getCacheMVELName();
            if (cache != null) {
                return cache;
            }
            if (!this.isSuspended()) {
                return null;
            }
            try {
                Object rem = this.getRemoteVar("sourceName");
                if (rem == null) {
                    return null;
                }
                StringReference res = (StringReference)rem;
                String realres = res.value();
                this.ctxCache.setCacheMVELName(realres);
                return realres;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (Throwable e) {
                DroolsEclipsePlugin.log(e);
            }
            try {
                Object rem = this.getRemoteVar("label");
                if (rem == null) {
                    return null;
                }
                ObjectReference obj = (ObjectReference)rem;
                ClassType frameType = (ClassType)obj.type();
                Field field = frameType.fieldByName("sourceFile");
                if ((rem = obj.getValue(field)) == null) {
                    return null;
                }
                StringReference res = (StringReference)rem;
                String realres = res.value();
                this.ctxCache.setCacheMVELName(realres);
                return realres;
            }
            catch (Throwable e) {
                DroolsEclipsePlugin.log(e);
                return "Unavailable";
            }
        }
    }

    private void evalEnd() {
        this.fireChangeEvent(256);
    }

    private Object getRemoteVar(String methodName) throws AbsentInformationException, ClassNotLoadedException, DebugException, InvalidTypeException, IncompatibleThreadStateException, InvocationException {
        Method method = this.getUnderlyingMethod();
        LocalVariable var = method.variables().get(0);
        ClassType frameType = (ClassType)var.type();
        StackFrame frame = this.getUnderlyingStackFrame();
        Value value = frame.getValue(var);
        ObjectReferenceImpl o = (ObjectReferenceImpl)value;
        if (o == null) {
            return null;
        }
        Field field = frameType.fieldByName(methodName);
        Value val = o.getValue(field);
        return val;
    }

    public String getSourcePath() throws DebugException {
        return this.getMVELName();
    }

    public String getSourceName() throws DebugException {
        return this.getMVELName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stepOver() throws DebugException {
        IThread iThread = this.getThread();
        synchronized (iThread) {
            this.ctxCache.clear();
        }
        super.stepOver();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canDropToFrame() {
        return false;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean canStepWithFilters() {
        return false;
    }

    public IJavaReferenceType getReferenceType() throws DebugException {
        return REF_TYPE;
    }

    public static class MVELStackFrameContext {
        private int cacheLineNumber = -1;
        private int cacheBreakpointLineNumber = -1;
        private String cacheMVELName = null;
        private IVariable[] cacheVariables = null;

        public synchronized void clear() {
            this.cacheLineNumber = -1;
            this.cacheBreakpointLineNumber = -1;
            this.cacheMVELName = null;
            this.cacheVariables = null;
        }

        public synchronized int getCacheLineNumber() {
            return this.cacheLineNumber;
        }

        public synchronized void setCacheLineNumber(int cacheLineNumber) {
            this.cacheLineNumber = cacheLineNumber;
        }

        public synchronized int getCacheBreakpointLineNumber() {
            return this.cacheBreakpointLineNumber;
        }

        public synchronized void setCacheBreakpointLineNumber(int cacheBreakpointLineNumber) {
            this.cacheBreakpointLineNumber = cacheBreakpointLineNumber;
        }

        public synchronized String getCacheMVELName() {
            return this.cacheMVELName;
        }

        public synchronized void setCacheMVELName(String cacheMVELName) {
            this.cacheMVELName = cacheMVELName;
        }

        public synchronized IVariable[] getCacheVariables() {
            return this.cacheVariables;
        }

        public synchronized void setCacheVariables(IVariable[] cacheVariables) {
            this.cacheVariables = cacheVariables;
        }
    }
}

