/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Keywords {
    private String[] allDrools = this.readKeywords("keywords.properties");
    private String[] allJava = this.readKeywords("java_keywords.properties");
    private String[] allMvel = this.readKeywords("mvel_keywords.properties");
    private static Keywords instance;

    public static Keywords getInstance() {
        if (instance == null) {
            instance = new Keywords();
        }
        return instance;
    }

    public String[] getAllDroolsKeywords() {
        return this.allDrools;
    }

    public String[] getAllJavaKeywords() {
        return this.allJava;
    }

    public String[] getAllMvelKeywords() {
        return this.allMvel;
    }

    private Keywords() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] readKeywords(String fileName) {
        String[] stringArray;
        InputStream stream = this.getClass().getResourceAsStream(fileName);
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            ArrayList<String> list = new ArrayList<String>();
            String line = null;
            while (true) {
                if ((line = reader.readLine()) == null) {
                    stringArray = list.toArray(new String[list.size()]);
                    break;
                }
                if (line.startsWith("#")) continue;
                list.add(line);
            }
        }
        catch (IOException iOException) {
            try {
                throw new IllegalArgumentException("Could not load keywords for editor.");
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    throw new IllegalStateException("Error closing stream.");
                }
            }
        }
        try {
            stream.close();
            return stringArray;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Error closing stream.");
        }
    }
}

