/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.editors.rete.model;

import org.drools.eclipse.editors.rete.model.ModelElement;
import org.drools.eclipse.reteoo.BaseVertex;

public class Connection
extends ModelElement {
    private boolean isConnected;
    private BaseVertex source;
    private BaseVertex target;

    public Connection(BaseVertex source, BaseVertex target) {
        this.source = source;
        this.target = target;
        source.addConnection(this);
        target.addConnection(this);
        this.isConnected = true;
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.removeConnection(this);
            this.target.removeConnection(this);
            this.isConnected = false;
        }
    }

    public BaseVertex getSource() {
        return this.source;
    }

    public BaseVertex getTarget() {
        return this.target;
    }

    public BaseVertex getOpposite(BaseVertex vertex) {
        if (vertex == null || !vertex.equals(this.getSource()) && !vertex.equals(this.getTarget())) {
            return null;
        }
        if (vertex.equals(this.getSource())) {
            return this.getTarget();
        }
        return this.getSource();
    }
}

