/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.common.editor.core.command;

import org.drools.eclipse.flow.common.editor.core.ElementConnection;
import org.drools.eclipse.flow.common.editor.core.ElementWrapper;
import org.eclipse.gef.commands.Command;

public class ReconnectElementConnectionSourceCommand
extends Command {
    private ElementConnection connection;
    private ElementWrapper target;
    private ElementWrapper oldSource;
    private ElementWrapper newSource;

    public boolean canExecute() {
        if (this.connection.getTarget().equals(this.newSource)) {
            return false;
        }
        for (ElementConnection connection : this.newSource.getOutgoingConnections()) {
            if (!connection.getTarget().equals(this.target) || connection.getSource().equals(this.oldSource)) continue;
            return false;
        }
        return this.newSource.acceptsOutgoingConnection(this.connection, this.target);
    }

    public void execute() {
        if (this.newSource != null) {
            this.connection.disconnect();
            this.connection.connect(this.newSource, this.target);
        }
    }

    public void setSource(ElementWrapper source) {
        this.newSource = source;
    }

    public void setConnection(ElementConnection connection) {
        this.connection = connection;
        this.target = connection.getTarget();
        this.oldSource = connection.getSource();
    }

    public void undo() {
        this.connection.disconnect();
        this.connection.connect(this.oldSource, this.target);
    }

    public void redo() {
        this.connection.disconnect();
        this.connection.connect(this.newSource, this.target);
    }
}

