/*
 * Decompiled with CFR 0.152.
 */
package org.drools.eclipse.flow.ruleflow.editor;

import java.util.ArrayList;
import java.util.List;
import org.drools.eclipse.DroolsEclipsePlugin;
import org.drools.eclipse.flow.ruleflow.skin.SkinManager;
import org.drools.eclipse.flow.ruleflow.skin.SkinProvider;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;

public class RuleFlowPaletteFactory {
    public static PaletteRoot createPalette() {
        PaletteRoot flowPalette = new PaletteRoot();
        flowPalette.addAll(RuleFlowPaletteFactory.createCategories(flowPalette));
        return flowPalette;
    }

    private static List<PaletteEntry> createCategories(PaletteRoot root) {
        ArrayList<PaletteEntry> categories = new ArrayList<PaletteEntry>();
        categories.add((PaletteEntry)RuleFlowPaletteFactory.createControlGroup(root));
        String skin = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Flow.Skin");
        SkinProvider skinProvider = SkinManager.getInstance().getSkinProvider(skin);
        categories.add((PaletteEntry)skinProvider.createComponentsDrawer());
        String flowNodes = DroolsEclipsePlugin.getDefault().getPluginPreferences().getString("Drools.FlowNodes");
        if (flowNodes.charAt(12) == '1') {
            categories.add((PaletteEntry)RuleFlowPaletteFactory.createWorkNodesDrawer(skinProvider.getWorkItemsName()));
        }
        return categories;
    }

    private static PaletteContainer createWorkNodesDrawer(String name) {
        PaletteDrawer drawer = new PaletteDrawer(name, null);
        return drawer;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("Control Group");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        entries.add(tool);
        String skin = DroolsEclipsePlugin.getDefault().getPreferenceStore().getString("Drools.Flow.Skin");
        SkinProvider skinProvider = SkinManager.getInstance().getSkinProvider(skin);
        entries.add(skinProvider.createConnectionEntry());
        controlGroup.addAll(entries);
        return controlGroup;
    }
}

