/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.utils;

import java.io.File;
import java.net.URISyntaxException;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.jgit.transport.URIish;
import org.kie.eclipse.IKieConstants;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public class PreferencesUtils
implements IKieConstants {
    public static String getRepoRoot(IKieRepositoryHandler repository) {
        String repoRoot;
        IKieServerHandler server = (IKieServerHandler)repository.getRoot();
        boolean useDefaultGitPath = server.getPreference("UseDefaultGitPath", false);
        String defaultRepoRoot = UIUtils.getDefaultRepositoryDir();
        if (useDefaultGitPath) {
            repoRoot = defaultRepoRoot;
        } else {
            defaultRepoRoot = String.valueOf(defaultRepoRoot) + File.separator + server.getPreferenceName(null).replace("|".charAt(0), File.separator.charAt(0));
            repoRoot = server.getPreference("RepositoryPath", defaultRepoRoot);
        }
        return repoRoot;
    }

    public static String getRepoPath(IKieRepositoryHandler repository) {
        return String.valueOf(PreferencesUtils.getRepoRoot(repository)) + File.separator + repository.getName();
    }

    public static URIish getRepoURI(IKieRepositoryHandler repository) {
        IKieServiceDelegate delegate = repository.getDelegate();
        String host = delegate.getServer().getHost();
        int port = delegate.getGitPort();
        String username = delegate.getUsername();
        return PreferencesUtils.getRepoURI(host, port, username, repository.getName());
    }

    public static URIish getRepoURI(String host, int port, String username, String repoName) {
        URIish uri = null;
        try {
            uri = new URIish("ssh://" + (username == null || username.isEmpty() ? "" : String.valueOf(username) + "@") + host + ":" + port + "/" + repoName);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return uri;
    }
}

