/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.tools.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.guvnor.tools.Activator;
import org.guvnor.tools.Messages;
import org.guvnor.tools.utils.GuvnorMetadataProps;
import org.guvnor.tools.utils.GuvnorMetadataUtils;
import org.guvnor.tools.utils.webdav.IWebDavClient;
import org.guvnor.tools.utils.webdav.ResourceProperties;
import org.guvnor.tools.utils.webdav.WebDavServerCache;
import org.guvnor.tools.wizards.GuvWizardModel;
import org.guvnor.tools.wizards.GuvnorMainConfigPage;
import org.guvnor.tools.wizards.IGuvnorWizard;
import org.guvnor.tools.wizards.SelectGuvnorRepPage;
import org.guvnor.tools.wizards.SelectGuvnorResourcesPage;
import org.guvnor.tools.wizards.SelectLocalTargetPage;

public class CheckoutWizard
extends Wizard
implements INewWizard,
IGuvnorWizard {
    private GuvnorMainConfigPage mainConfigPage;
    private SelectGuvnorRepPage selectRepPage;
    private SelectGuvnorResourcesPage selectResPage;
    private SelectLocalTargetPage selectLocalTargetPage;
    private GuvWizardModel model = new GuvWizardModel();

    @Override
    public GuvWizardModel getModel() {
        return this.model;
    }

    public void addPages() {
        this.selectRepPage = new SelectGuvnorRepPage("select_rep_page", Messages.getString("select.guvnor.rep"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectRepPage.setDescription(Messages.getString("select.guvnor.rep.desc"));
        super.addPage((IWizardPage)this.selectRepPage);
        this.mainConfigPage = new GuvnorMainConfigPage("config_page", Messages.getString("new.guvnor.rep"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.mainConfigPage.setDescription(Messages.getString("new.guvnor.rep.desc"));
        super.addPage((IWizardPage)this.mainConfigPage);
        this.selectResPage = new SelectGuvnorResourcesPage("select_res_page", Messages.getString("select.resources"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectResPage.setDescription(Messages.getString("select.resources.desc"));
        super.addPage((IWizardPage)this.selectResPage);
        this.selectLocalTargetPage = new SelectLocalTargetPage("local_target_page", Messages.getString("select.target.loc"), Activator.getImageDescriptor("guvnor_rep_wizban.gif"));
        this.selectLocalTargetPage.setDescription(Messages.getString("select.target.loc.desc"));
        super.addPage((IWizardPage)this.selectLocalTargetPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.getName().equals("select_rep_page")) {
            if (this.model.shouldCreateNewRep()) {
                return this.mainConfigPage;
            }
            return this.selectResPage;
        }
        if (page.getName().equals("config_page")) {
            return this.selectResPage;
        }
        if (page.getName().equals("select_res_page")) {
            return this.selectLocalTargetPage;
        }
        return null;
    }

    public boolean performFinish() {
        try {
            IWebDavClient webdav = WebDavServerCache.getWebDavClient(this.model.getRepLocation());
            assert (webdav != null);
            for (String oneResource : this.model.getResources()) {
                ResourceProperties resprops = webdav.queryProperties(oneResource);
                if (resprops == null) {
                    throw new Exception("Null resource properties for " + oneResource);
                }
                String contents = webdav.getResourceContents(oneResource);
                Path targetLocation = new Path(this.model.getTargetLocation());
                IWorkspaceRoot root = Activator.getDefault().getWorkspace().getRoot();
                IFile targetFile = root.getFile(targetLocation.append(oneResource.substring(oneResource.lastIndexOf(47))));
                if (targetFile.exists()) {
                    targetFile = this.resolveNameConflict(targetFile);
                }
                if (targetFile == null) continue;
                ByteArrayInputStream bis = new ByteArrayInputStream(contents.getBytes(targetFile.getCharset()));
                if (targetFile.exists()) {
                    targetFile.setContents((InputStream)bis, true, true, null);
                } else {
                    targetFile.create((InputStream)bis, true, null);
                }
                GuvnorMetadataProps mdProps = new GuvnorMetadataProps(targetFile.getName(), this.model.getRepLocation(), oneResource, resprops.getLastModifiedDate(), resprops.getRevision());
                GuvnorMetadataUtils.setGuvnorMetadataProps(targetFile.getFullPath(), mdProps);
                GuvnorMetadataUtils.markCurrentGuvnorResource((IResource)targetFile);
            }
        }
        catch (Exception e) {
            Activator.getDefault().displayError(4, e.getMessage(), e, true);
        }
        return true;
    }

    public IFile resolveNameConflict(IFile conflictingFile) {
        final IWorkspaceRoot root = Activator.getDefault().getWorkspace().getRoot();
        final IPath basePath = conflictingFile.getFullPath().removeLastSegments(1);
        InputDialog dialog = new InputDialog(super.getShell(), Messages.getString("name.conflict"), MessageFormat.format(Messages.getString("name.conflict.request"), conflictingFile.getName()), String.valueOf(Messages.getString("copy.of")) + conflictingFile.getName(), new IInputValidator(){

            public String isValid(String newText) {
                IFile temp = root.getFile(basePath.append(newText));
                if (temp == null || !temp.exists()) {
                    return null;
                }
                return MessageFormat.format(Messages.getString("already.exists"), newText);
            }
        });
        if (dialog.open() == 0) {
            return root.getFile(basePath.append(dialog.getValue()));
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return this.model.getRepLocation() != null && this.model.getTargetLocation() != null && this.model.getResources() != null;
    }
}

