/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.authentication;

import org.eclipse.webdav.internal.authentication.ParserException;

public class Parser {
    public String s;
    public int pos;

    public Parser(String s) {
        this.s = s;
    }

    public void checkPosition() throws ParserException {
        if (this.pos < 0 || this.pos >= this.s.length()) {
            throw new ParserException();
        }
    }

    public void match(char c) throws ParserException {
        this.checkPosition();
        if (this.s.charAt(this.pos) != c) {
            throw new ParserException();
        }
        ++this.pos;
    }

    public String nextQuotedString() throws ParserException {
        int start = this.pos;
        this.match('\"');
        this.checkPosition();
        while (this.s.charAt(this.pos) != '\"') {
            ++this.pos;
            this.checkPosition();
        }
        this.match('\"');
        return this.s.substring(start, this.pos);
    }

    public String nextToken() throws ParserException {
        int start = this.pos;
        this.checkPosition();
        boolean done = false;
        while (!done && this.pos < this.s.length()) {
            char c = this.s.charAt(this.pos);
            if (c <= '\u001f' || c == '\u007f' || c == '(' || c == ')' || c == '<' || c == '>' || c == '@' || c == ',' || c == ';' || c == ':' || c == '\\' || c == '\"' || c == '/' || c == '[' || c == ']' || c == '?' || c == '=' || c == '{' || c == '}' || Character.isWhitespace(c)) {
                done = true;
                continue;
            }
            ++this.pos;
        }
        if (start == this.pos) {
            throw new ParserException();
        }
        return this.s.substring(start, this.pos);
    }

    public void skipWhiteSpace() {
        while (this.pos < this.s.length() && Character.isWhitespace(this.s.charAt(this.pos))) {
            ++this.pos;
        }
    }
}

