/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.webdav.IContext;
import org.eclipse.webdav.internal.kernel.utils.EnumerationConverter;
import org.eclipse.webdav.internal.kernel.utils.MergedEnumeration;

public class Context
implements IContext {
    protected Hashtable properties = new Hashtable(5);
    protected IContext defaults = null;
    public final String ACCEPT = "Accept";
    public final String ACCEPT_CHARSET = "Accept-Charset";
    public final String ACCEPT_ENCODING = "Accept-Encoding";
    public final String ACCEPT_LANGUAGE = "Accept-Language";
    public final String ACCEPT_RANGES = "Accept-Ranges";
    public final String AGE = "Age";
    public final String ALLOW = "Allow";
    public final String AUTHORIZATION = "Authorization";
    public final String CACHE_CONTROL = "Cache-Control";
    public final String CONNECTION = "Connection";
    public final String CONTENT_BASE = "Content-Base";
    public final String CONTENT_ENCODING = "Content-Encoding";
    public final String CONTENT_LANGUAGE = "Content-Language";
    public final String CONTENT_LENGTH = "Content-Length";
    public final String CONTENT_LOCATION = "Content-Location";
    public final String CONTENT_MD5 = "Content-MD5";
    public final String CONTENT_RANGE = "Content-Range";
    public final String CONTENT_TYPE = "Content-Type";
    public final String DATE = "Date";
    public final String ETAG = "ETag";
    public final String EXPIRES = "Expires";
    public final String FROM = "From";
    public final String HOST = "Host";
    public final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public final String IF_MATCH = "If-Match";
    public final String IF_NONE_MATCH = "If-None-Match";
    public final String IF_RANGE = "If-Range";
    public final String IF_UNMODIFIED_SINCE = "If-Unmodified-Since";
    public final String LAST_MODIFIED = "Last-Modified";
    public final String LOCATION = "Location";
    public final String MAX_FORWARDS = "Max-Forwards";
    public final String PRAGMA = "Pragma";
    public final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public final String PUBLIC = "Public";
    public final String RANGE = "Range";
    public final String REFERER = "Referer";
    public final String RETRY_AFTER = "Retry-After";
    public final String SERVER = "Server";
    public final String TRANSFER_ENCODING = "Transfer-Encoding";
    public final String UPGRADE = "Upgrade";
    public final String USER_AGENT = "User-Agent";
    public final String VARY = "Vary";
    public final String VIA = "Via";
    public final String WARNING = "Warning";
    public final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public final String DAV = "DAV";
    public final String DEPTH = "Depth";
    public final String DESTINATION = "Destination";
    public final String IF = "If";
    public final String LOCK_TOKEN = "Lock-Token";
    public final String OVERWRITE = "Overwrite";
    public final String STATUS_URI = "Status-URI";
    public final String TIMEOUT = "Timeout";
    public final String ALL_BINDINGS = "All-Bindings";
    public final String REF_TARGET = "Ref-Target";
    public final String RES_TYPE = "Resource-Type";
    public final String PASSTHROUGH = "Passthrough";
    public final String ORDERED = "Ordered";
    public final String POSITION = "Position";
    public final String LABEL = "Label";

    public Context() {
    }

    public Context(IContext defaults) {
        this.defaults = defaults;
    }

    @Override
    public void collapse() {
        if (this.defaults != null) {
            Enumeration keysEnum = this.defaults.keys();
            while (keysEnum.hasMoreElements()) {
                String key = (String)keysEnum.nextElement();
                this.put(key, this.get(key));
            }
            this.defaults = null;
        }
    }

    @Override
    public String get(String key) {
        String value = (String)this.properties.get(new ContextKey(key));
        if (value == null && this.defaults != null) {
            return this.defaults.get(key);
        }
        return value;
    }

    @Override
    public String getAccept() {
        return this.get("Accept");
    }

    @Override
    public String getAcceptCharset() {
        return this.get("Accept-Charset");
    }

    @Override
    public String getAcceptEncoding() {
        return this.get("Accept-Encoding");
    }

    @Override
    public String getAcceptLanguage() {
        return this.get("Accept-Language");
    }

    @Override
    public String getAcceptRanges() {
        return this.get("Accept-Ranges");
    }

    @Override
    public int getAge() {
        String ageString = this.get("Age");
        return ageString == null ? -1 : Integer.parseInt(ageString);
    }

    @Override
    public String getAllBindings() {
        return this.get("All-Bindings");
    }

    @Override
    public String getAllow() {
        return this.get("Allow");
    }

    @Override
    public String getAuthorization() {
        return this.get("Authorization");
    }

    @Override
    public String getCacheControl() {
        return this.get("Cache-Control");
    }

    @Override
    public String getConnection() {
        return this.get("Connection");
    }

    @Override
    public String getContentBase() {
        return this.get("Content-Base");
    }

    @Override
    public String getContentEncoding() {
        return this.get("Content-Encoding");
    }

    @Override
    public String getContentLanguage() {
        return this.get("Content-Language");
    }

    @Override
    public long getContentLength() {
        String lengthString = this.get("Content-Length");
        return lengthString == null ? -1L : Long.parseLong(lengthString);
    }

    @Override
    public String getContentLocation() {
        return this.get("Content-Location");
    }

    @Override
    public String getContentMD5() {
        return this.get("Content-MD5");
    }

    @Override
    public String getContentRange() {
        return this.get("Content-Range");
    }

    @Override
    public String getContentType() {
        return this.get("Content-Type");
    }

    @Override
    public String getDate() {
        return this.get("Date");
    }

    @Override
    public String getDAV() {
        return this.get("DAV");
    }

    @Override
    public String getDepth() {
        return this.get("Depth");
    }

    @Override
    public String getDestination() {
        return this.get("Destination");
    }

    @Override
    public String getETag() {
        return this.get("ETag");
    }

    @Override
    public String getExpires() {
        return this.get("Expires");
    }

    @Override
    public String getFrom() {
        return this.get("From");
    }

    @Override
    public String getHost() {
        return this.get("Host");
    }

    @Override
    public String getIfKey() {
        return this.get("If");
    }

    @Override
    public String getIfMatch() {
        return this.get("If-Match");
    }

    @Override
    public String getIfModifiedSince() {
        return this.get("If-Modified-Since");
    }

    @Override
    public String getIfNoneMatch() {
        return this.get("If-None-Match");
    }

    @Override
    public String getIfRange() {
        return this.get("If-Range");
    }

    @Override
    public String getIfUnmodifiedSince() {
        return this.get("If-Unmodified-Since");
    }

    @Override
    public String getLabel() {
        return this.get("Label");
    }

    @Override
    public String getLastModified() {
        return this.get("Last-Modified");
    }

    @Override
    public String getLocation() {
        return this.get("Location");
    }

    @Override
    public String getLockToken() {
        return this.get("Lock-Token");
    }

    @Override
    public int getMaxForwards() {
        String s = this.get("Max-Forwards");
        return s == null ? -1 : Integer.parseInt(s);
    }

    @Override
    public String getOrdered() {
        return this.get("Ordered");
    }

    @Override
    public boolean getOverwrite() {
        String overwriteString = this.get("Overwrite");
        return overwriteString == null ? false : overwriteString.equalsIgnoreCase("T");
    }

    @Override
    public boolean getPassthrough() {
        String s = this.get("Passthrough");
        return s == null ? false : s.equalsIgnoreCase("T");
    }

    @Override
    public String getPosition() {
        return this.get("Position");
    }

    @Override
    public String getPragma() {
        return this.get("Pragma");
    }

    public String getPrecondition() {
        return this.get("If");
    }

    @Override
    public String getProxyAuthenticate() {
        return this.get("Proxy-Authenticate");
    }

    @Override
    public String getProxyAuthorization() {
        return this.get("Proxy-Authorization");
    }

    @Override
    public String getPublicKey() {
        return this.get("Public");
    }

    @Override
    public String getRange() {
        return this.get("Range");
    }

    @Override
    public String getReferer() {
        return this.get("Referer");
    }

    @Override
    public String getRefTarget() {
        return this.get("Ref-Target");
    }

    @Override
    public String getResourceType() {
        return this.get("Resource-Type");
    }

    @Override
    public String getRetryAfter() {
        return this.get("Retry-After");
    }

    @Override
    public String getServer() {
        return this.get("Server");
    }

    @Override
    public String getStatusURI() {
        return this.get("Status-URI");
    }

    @Override
    public int getTimeout() {
        String timeoutString = this.get("Timeout");
        if (timeoutString == null) {
            return -1;
        }
        if (timeoutString.equalsIgnoreCase("infinity")) {
            return -2;
        }
        if (timeoutString.regionMatches(true, 1, "Second-", 1, 7)) {
            return Integer.parseInt(timeoutString.substring(7));
        }
        return -2;
    }

    @Override
    public String getTransferEncoding() {
        return this.get("Transfer-Encoding");
    }

    @Override
    public String getUpgrade() {
        return this.get("Upgrade");
    }

    @Override
    public String getUserAgent() {
        return this.get("User-Agent");
    }

    @Override
    public String getVary() {
        return this.get("Vary");
    }

    @Override
    public String getVia() {
        return this.get("Via");
    }

    @Override
    public String getWarning() {
        return this.get("Warning");
    }

    @Override
    public String getWWWAuthenticate() {
        return this.get("WWW-Authenticate");
    }

    @Override
    public Enumeration keys() {
        if (this.defaults == null) {
            return new ContextKeyToStringEnum(this.properties.keys());
        }
        MergedEnumeration allKeys = new MergedEnumeration(new ContextKeyToStringEnum(this.properties.keys()), this.defaults.keys());
        Hashtable keysSet = new Hashtable();
        while (allKeys.hasMoreElements()) {
            keysSet.put(allKeys.nextElement(), "ignored");
        }
        return keysSet.keys();
    }

    @Override
    public void put(String key, String value) {
        ContextKey ckey = new ContextKey(key);
        if (value == null || value.length() == 0) {
            this.properties.remove(ckey);
        } else {
            this.properties.put(ckey, value);
        }
    }

    @Override
    public void removeKey(String key) {
        this.properties.remove(new ContextKey(key));
    }

    @Override
    public void setAccept(String value) {
        this.put("Accept", value);
    }

    @Override
    public void setAcceptCharset(String value) {
        this.put("Accept-Charset", value);
    }

    @Override
    public void setAcceptEncoding(String value) {
        this.put("Accept-Encoding", value);
    }

    public String setAcceptLanguage() {
        return this.get("Accept-Language");
    }

    @Override
    public void setAcceptLanguage(String value) {
        this.put("Accept-Language", value);
    }

    @Override
    public void setAcceptRanges(String value) {
        this.put("Accept-Ranges", value);
    }

    @Override
    public void setAge(int seconds) {
        this.put("Age", seconds == -1 ? "" : Integer.toString(seconds));
    }

    @Override
    public void setAllBindings(String s) {
        this.put("All-Bindings", s);
    }

    @Override
    public void setAllow(String value) {
        this.put("Allow", value);
    }

    @Override
    public void setAuthorization(String value) {
        this.put("Authorization", value);
    }

    @Override
    public void setCacheControl(String value) {
        this.put("Cache-Control", value);
    }

    @Override
    public void setConnection(String value) {
        this.put("Connection", value);
    }

    @Override
    public void setContentBase(String url) {
        this.put("Content-Base", url);
    }

    @Override
    public void setContentEncoding(String value) {
        this.put("Content-Encoding", value);
    }

    @Override
    public void setContentLanguage(String value) {
        this.put("Content-Language", value);
    }

    @Override
    public void setContentLength(long value) {
        this.put("Content-Length", value == -1L ? "" : Long.toString(value));
    }

    @Override
    public void setContentLocation(String value) {
        this.put("Content-Location", value);
    }

    @Override
    public void setContentMD5(String value) {
        this.put("Content-MD5", value);
    }

    @Override
    public void setContentRange(String value) {
        this.put("Content-Range", value);
    }

    @Override
    public void setContentType(String value) {
        this.put("Content-Type", value);
    }

    @Override
    public void setDate(String value) {
        this.put("Date", value);
    }

    @Override
    public void setDAV(String value) {
        this.put("DAV", value);
    }

    @Override
    public void setDepth(String s) {
        this.put("Depth", s);
    }

    @Override
    public void setDestination(String value) {
        this.put("Destination", value);
    }

    @Override
    public void setETag(String value) {
        this.put("ETag", value);
    }

    @Override
    public void setExpires(String value) {
        this.put("Expires", value);
    }

    @Override
    public void setFrom(String s) {
        this.put("From", s);
    }

    @Override
    public void setHost(String value) {
        this.put("Host", value);
    }

    @Override
    public void setIfKey(String s) {
        this.put("If", s);
    }

    @Override
    public void setIfMatch(String s) {
        this.put("If-Match", s);
    }

    @Override
    public void setIfModifiedSince(String s) {
        this.put("If-Modified-Since", s);
    }

    @Override
    public void setIfNoneMatch(String s) {
        this.put("If-None-Match", s);
    }

    @Override
    public void setIfRange(String s) {
        this.put("If-Range", s);
    }

    @Override
    public void setIfUnmodifiedSince(String s) {
        this.put("If-Unmodified-Since", s);
    }

    @Override
    public void setLabel(String value) {
        this.put("Label", value);
    }

    @Override
    public void setLastModified(String value) {
        this.put("Last-Modified", value);
    }

    @Override
    public void setLocation(String value) {
        this.put("Location", value);
    }

    @Override
    public void setLockToken(String token) {
        this.put("Lock-Token", token);
    }

    @Override
    public void setMaxForwards(int i) {
        this.put("Max-Forwards", Integer.toString(i));
    }

    @Override
    public void setOrdered(String value) {
        this.put("Ordered", value);
    }

    @Override
    public void setOverwrite(boolean value) {
        this.put("Overwrite", value ? "T" : "F");
    }

    @Override
    public void setPassthrough(boolean value) {
        this.put("Passthrough", value ? "T" : "F");
    }

    @Override
    public void setPosition(String s) {
        this.put("Position", s);
    }

    @Override
    public void setPragma(String value) {
        this.put("Pragma", value);
    }

    public void setPrecondition(String value) {
        this.put("If", value);
    }

    @Override
    public void setProxyAuthenticate(String value) {
        this.put("Proxy-Authenticate", value);
    }

    @Override
    public void setProxyAuthorization(String value) {
        this.put("Proxy-Authorization", value);
    }

    @Override
    public void setPublicKey(String value) {
        this.put("Public", value);
    }

    @Override
    public void setRange(String value) {
        this.put("Range", value);
    }

    @Override
    public void setReferer(String value) {
        this.put("Referer", value);
    }

    @Override
    public void setRefTarget(String value) {
        this.put("Ref-Target", value);
    }

    @Override
    public void setResourceType(String value) {
        this.put("Resource-Type", value);
    }

    @Override
    public void setRetryAfter(String value) {
        this.put("Retry-After", value);
    }

    @Override
    public void setServer(String value) {
        this.put("Server", value);
    }

    @Override
    public void setStatusURI(String value) {
        this.put("Status-URI", value);
    }

    @Override
    public void setTimeout(int value) {
        if (value == -1) {
            this.put("Timeout", "");
        } else {
            this.put("Timeout", value == -2 ? "infinity" : "Second-" + Integer.toString(value));
        }
    }

    @Override
    public void setTransferEncoding(String value) {
        this.put("Transfer-Encoding", value);
    }

    @Override
    public void setUpgrade(String value) {
        this.put("Upgrade", value);
    }

    @Override
    public void setUserAgent(String value) {
        this.put("User-Agent", value);
    }

    @Override
    public void setVary(String value) {
        this.put("Vary", value);
    }

    @Override
    public void setVia(String value) {
        this.put("Via", value);
    }

    @Override
    public void setWarning(String value) {
        this.put("Warning", value);
    }

    @Override
    public void setWWWAuthenticate(String value) {
        this.put("WWW-Authenticate", value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Enumeration keysEnum = this.keys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            buffer.append(key);
            buffer.append(": ");
            buffer.append(this.get(key));
            buffer.append('\n');
        }
        return buffer.toString();
    }

    protected final class ContextKey {
        protected String key;

        public ContextKey(String key) {
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ContextKey)) {
                return false;
            }
            return ((ContextKey)obj).key.equalsIgnoreCase(this.key);
        }

        public int hashCode() {
            return this.key.toLowerCase().hashCode();
        }

        public String toString() {
            return this.key;
        }
    }

    public final class ContextKeyToStringEnum
    extends EnumerationConverter {
        ContextKeyToStringEnum(Enumeration sourceEnum) {
            super(sourceEnum);
        }

        @Override
        public Object nextElement() {
            return ((ContextKey)this.sourceEnum.nextElement()).key;
        }
    }
}

