/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.webdav.internal.kernel.utils;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.webdav.internal.kernel.utils.MergedEnumeration;

public class NestedHashtable {
    protected Hashtable localValues = new Hashtable(5);
    protected NestedHashtable defaults = null;

    public NestedHashtable() {
    }

    public NestedHashtable(NestedHashtable defaults) {
        this.defaults = defaults;
    }

    public void collapse() {
        if (this.defaults != null) {
            Enumeration keysEnum = this.defaults.keys();
            while (keysEnum.hasMoreElements()) {
                Object key = keysEnum.nextElement();
                this.localValues.put(key, this.defaults.get(key));
            }
            this.defaults = null;
        }
    }

    public Object get(Object key) {
        Object value = this.localValues.get(key);
        if (value == null && this.defaults != null) {
            return this.defaults.get(key);
        }
        return value;
    }

    public Enumeration keys() {
        if (this.defaults == null) {
            return this.localValues.keys();
        }
        return new MergedEnumeration(this.localValues.keys(), this.defaults.keys());
    }

    public void put(Object key, Object value) {
        this.localValues.put(key, value);
    }

    public Object remove(Object key) {
        return this.localValues.remove(key);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Enumeration keysEnum = this.keys();
        while (keysEnum.hasMoreElements()) {
            Object key = keysEnum.nextElement();
            buffer.append(key.toString());
            buffer.append(": ");
            buffer.append(this.get(key).toString());
            buffer.append('\n');
        }
        return buffer.toString();
    }
}

