/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command;

import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

public class NewKieSessionCommand
implements ExecutableCommand<KieSession> {
    private static final long serialVersionUID = 8748826714594402049L;
    private String sessionId;
    private ReleaseId releaseId;

    public NewKieSessionCommand(String sessionId) {
        this.sessionId = sessionId;
    }

    public NewKieSessionCommand(ReleaseId releaseId, String sessionId) {
        this.sessionId = sessionId;
        this.releaseId = releaseId;
    }

    @Override
    public KieSession execute(Context context) {
        KieContainer kieContainer;
        if (this.releaseId != null) {
            KieServices kieServices = KieServices.Factory.get();
            kieContainer = kieServices.newKieContainer(this.releaseId);
        } else {
            kieContainer = ((RegistryContext)context).lookup(KieContainer.class);
            if (kieContainer == null) {
                throw new RuntimeException("ReleaseId was not specfied, nor was an existing KieContainer assigned to the Registry");
            }
        }
        KieSession ksession = this.sessionId != null ? kieContainer.newKieSession(this.sessionId) : kieContainer.newKieSession();
        ((RegistryContext)context).register(KieSession.class, ksession);
        return ksession;
    }

    public String toString() {
        return "NewKieSessionCommand{sessionId='" + this.sessionId + '\'' + ", releaseId=" + this.releaseId + '}';
    }
}

