/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import org.drools.core.command.impl.ExecutableCommand;
import org.drools.core.command.impl.RegistryContext;
import org.drools.core.common.InternalFactHandle;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.api.runtime.rule.FactHandle;

public class GetFactHandleInEntryPointCommand
implements ExecutableCommand<FactHandle> {
    private Object object;
    private boolean disconnected;
    private String entryPoint;

    public GetFactHandleInEntryPointCommand() {
    }

    public GetFactHandleInEntryPointCommand(Object object, String entryPoint) {
        this.object = object;
        this.entryPoint = entryPoint;
        this.disconnected = false;
    }

    public GetFactHandleInEntryPointCommand(Object object, String entryPoint, boolean disconnected) {
        this.object = object;
        this.entryPoint = entryPoint;
        this.disconnected = disconnected;
    }

    @Override
    public FactHandle execute(Context context) {
        KieSession ksession = ((RegistryContext)context).lookup(KieSession.class);
        EntryPoint ep = ksession.getEntryPoint(this.entryPoint);
        InternalFactHandle factHandle = (InternalFactHandle)ep.getFactHandle(this.object);
        if (factHandle != null) {
            InternalFactHandle handle = factHandle.clone();
            if (this.disconnected) {
                handle.disconnect();
            }
            return handle;
        }
        return null;
    }

    public String toString() {
        return "ksession.getEntryPoint( " + this.entryPoint + " ).getFactHandle( " + this.object + " );";
    }
}

