/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.DoubleBetaConstraints;
import org.drools.core.common.DoubleNonIndexSkipBetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.QuadroupleBetaConstraints;
import org.drools.core.common.QuadroupleNonIndexSkipBetaConstraints;
import org.drools.core.common.RuleBasePartitionId;
import org.drools.core.common.SingleBetaConstraints;
import org.drools.core.common.SingleNonIndexSkipBetaConstraints;
import org.drools.core.common.TripleBetaConstraints;
import org.drools.core.common.TripleNonIndexSkipBetaConstraints;
import org.drools.core.common.TupleSets;
import org.drools.core.common.UpdateContext;
import org.drools.core.phreak.AddRemoveRule;
import org.drools.core.phreak.SegmentUtilities;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.MemoryVisitor;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.ObjectSinkNode;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PropertySpecificUtil;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleImpl;
import org.drools.core.reteoo.RightTupleSink;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.IndexableConstraint;
import org.drools.core.rule.Pattern;
import org.drools.core.spi.BetaNodeFieldConstraint;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.drools.core.util.ClassUtils;
import org.drools.core.util.FastIterator;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.index.IndexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BetaNode
extends LeftTupleSource
implements LeftTupleSinkNode,
ObjectSinkNode,
RightTupleSink,
MemoryFactory {
    protected static final Logger log = LoggerFactory.getLogger(BetaNode.class);
    protected static final boolean isLogTraceEnabled = log.isTraceEnabled();
    protected ObjectSource rightInput;
    protected BetaConstraints constraints;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;
    private ObjectSinkNode previousObjectSinkNode;
    private ObjectSinkNode nextObjectSinkNode;
    protected boolean objectMemory = true;
    protected boolean tupleMemoryEnabled;
    protected boolean indexedUnificationJoin;
    private BitMask rightDeclaredMask = EmptyBitMask.get();
    private BitMask rightInferredMask = EmptyBitMask.get();
    private BitMask rightNegativeMask = EmptyBitMask.get();
    private List<String> leftListenedProperties;
    private List<String> rightListenedProperties;
    private transient ObjectTypeNode.Id rightInputOtnId = ObjectTypeNode.DEFAULT_ID;
    private boolean rightInputIsRiaNode;
    private transient ObjectTypeNode objectTypeNode;
    private boolean rightInputIsPassive;

    public BetaNode() {
    }

    BetaNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, BetaConstraints constraints, BuildContext context) {
        super(id, context);
        this.setLeftTupleSource(leftInput);
        this.rightInput = rightInput;
        this.rightInputIsRiaNode = 71 == rightInput.getType();
        this.setConstraints(constraints);
        if (this.constraints == null) {
            throw new RuntimeException("cannot have null constraints, must at least be an instance of EmptyBetaConstraints");
        }
        this.constraints.registerEvaluationContext(context);
        this.initMasks(context, leftInput);
        this.setStreamMode(context.isStreamMode() && this.getObjectTypeNode(context).getObjectType().isEvent());
        this.hashcode = this.calculateHashCode();
    }

    private ObjectTypeNode getObjectTypeNode(BuildContext context) {
        ObjectTypeNode otn = this.getObjectTypeNode();
        return otn != null ? otn : context.getRootObjectTypeNode();
    }

    @Override
    protected void initDeclaredMask(BuildContext context, LeftTupleSource leftInput) {
        if (context == null || context.getLastBuiltPatterns() == null) {
            this.rightDeclaredMask = AllSetBitMask.get();
            super.initDeclaredMask(context, leftInput);
            return;
        }
        Pattern pattern = context.getLastBuiltPatterns()[0];
        this.rightInputIsPassive = pattern.isPassive();
        if (!this.isRightInputIsRiaNode()) {
            ObjectType objectType = pattern.getObjectType();
            if (objectType instanceof ClassObjectType) {
                Class<?> objectClass = ((ClassObjectType)objectType).getClassType();
                if (PropertySpecificUtil.isPropertyReactive(context, objectClass)) {
                    this.rightListenedProperties = pattern.getListenedProperties();
                    List<String> settableProperties = PropertySpecificUtil.getSettableProperties(context.getKnowledgeBase(), objectClass);
                    this.rightDeclaredMask = PropertySpecificUtil.calculatePositiveMask(this.rightListenedProperties, settableProperties);
                    this.rightDeclaredMask = this.rightDeclaredMask.setAll(this.constraints.getListenedPropertyMask(settableProperties));
                    this.rightNegativeMask = PropertySpecificUtil.calculateNegativeMask(this.rightListenedProperties, settableProperties);
                } else {
                    this.rightDeclaredMask = AllSetBitMask.get();
                }
            } else {
                this.rightDeclaredMask = AllSetBitMask.get();
            }
        } else {
            this.rightDeclaredMask = AllSetBitMask.get();
            context.setLastBuiltPattern(context.getLastBuiltPatterns()[0]);
        }
        super.initDeclaredMask(context, leftInput);
    }

    @Override
    public void setPartitionId(BuildContext context, RuleBasePartitionId partitionId) {
        if (this.rightInput.getPartitionId() != RuleBasePartitionId.MAIN_PARTITION && !this.rightInput.getPartitionId().equals(partitionId)) {
            this.partitionId = this.rightInput.getPartitionId();
            context.setPartitionId(this.partitionId);
            this.leftInput.setSourcePartitionId(context, this.partitionId);
        } else {
            this.partitionId = partitionId;
        }
    }

    @Override
    protected void setLeftListenedProperties(List<String> leftListenedProperties) {
        this.leftListenedProperties = leftListenedProperties;
    }

    public void initInferredMask() {
        this.initInferredMask(this.leftInput);
    }

    @Override
    protected void initInferredMask(LeftTupleSource leftInput) {
        super.initInferredMask(leftInput);
        ObjectSource unwrappedRight = this.unwrapRightInput();
        if (unwrappedRight.getType() == 40) {
            AlphaNode alphaNode = (AlphaNode)unwrappedRight;
            this.rightInferredMask = alphaNode.updateMask(this.rightDeclaredMask);
        } else {
            this.rightInferredMask = this.rightDeclaredMask;
        }
        this.rightInferredMask = this.rightInferredMask.resetAll(this.rightNegativeMask);
    }

    public ObjectSource unwrapRightInput() {
        return this.rightInput.getType() == 50 ? this.rightInput.getParentObjectSource() : this.rightInput;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraints = (BetaConstraints)in.readObject();
        this.objectMemory = in.readBoolean();
        this.tupleMemoryEnabled = in.readBoolean();
        this.rightDeclaredMask = (BitMask)in.readObject();
        this.rightInferredMask = (BitMask)in.readObject();
        this.rightNegativeMask = (BitMask)in.readObject();
        this.leftListenedProperties = (List)in.readObject();
        this.rightListenedProperties = (List)in.readObject();
        this.rightInputIsPassive = in.readBoolean();
        this.setUnificationJoin();
        super.readExternal(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        BetaNodeFieldConstraint c;
        BetaNodeFieldConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0 && IndexUtil.isIndexable(c = betaCconstraints[0], this.getType()) && ((IndexableConstraint)((Object)c)).isUnification()) {
            this.setConstraints(this.constraints.getOriginalConstraint());
        }
        out.writeObject(this.constraints);
        out.writeBoolean(this.objectMemory);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.rightDeclaredMask);
        out.writeObject(this.rightInferredMask);
        out.writeObject(this.rightNegativeMask);
        out.writeObject(this.leftListenedProperties);
        out.writeObject(this.rightListenedProperties);
        out.writeBoolean(this.rightInputIsPassive);
        super.writeExternal(out);
    }

    public void setUnificationJoin() {
        BetaNodeFieldConstraint c;
        BetaNodeFieldConstraint[] betaCconstraints = this.constraints.getConstraints();
        if (betaCconstraints.length > 0 && IndexUtil.isIndexable(c = betaCconstraints[0], this.getType()) && ((IndexableConstraint)((Object)c)).isUnification()) {
            if (this.constraints instanceof SingleBetaConstraints) {
                this.setConstraints(new SingleNonIndexSkipBetaConstraints((SingleBetaConstraints)this.constraints));
            } else if (this.constraints instanceof DoubleBetaConstraints) {
                this.setConstraints(new DoubleNonIndexSkipBetaConstraints((DoubleBetaConstraints)this.constraints));
            } else if (this.constraints instanceof TripleBetaConstraints) {
                this.setConstraints(new TripleNonIndexSkipBetaConstraints((TripleBetaConstraints)this.constraints));
            } else if (this.constraints instanceof QuadroupleBetaConstraints) {
                this.setConstraints(new QuadroupleNonIndexSkipBetaConstraints((QuadroupleBetaConstraints)this.constraints));
            }
            this.indexedUnificationJoin = true;
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext pctx, InternalWorkingMemory wm) {
        BetaMemory memory = BetaNode.getBetaMemoryFromRightInput(this, wm);
        RightTuple rightTuple = this.createRightTuple(factHandle, this, pctx);
        boolean stagedInsertWasEmpty = memory.getStagedRightTuples().addInsert(rightTuple);
        if (isLogTraceEnabled) {
            log.trace("BetaNode stagedInsertWasEmpty={}", (Object)stagedInsertWasEmpty);
        }
        boolean shouldFlush = this.isStreamMode();
        if (memory.getAndIncCounter() == 0) {
            if (stagedInsertWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            shouldFlush = memory.linkNode(wm, !this.rightInputIsPassive) | shouldFlush;
        } else if (stagedInsertWasEmpty) {
            shouldFlush = memory.setNodeDirty(wm, !this.rightInputIsPassive) | shouldFlush;
        }
        if (shouldFlush) {
            AddRemoveRule.flushLeftTupleIfNecessary(wm, memory.getSegmentMemory(), this.isStreamMode());
        }
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory wm) {
        BetaMemory bm;
        RightTuple rightTuple = modifyPreviousTuples.peekRightTuple();
        while (rightTuple != null && rightTuple.getInputOtnId().before(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.setPropagationContext(context);
            bm = BetaNode.getBetaMemory((BetaNode)rightTuple.getTupleSink(), wm);
            ((BetaNode)rightTuple.getTupleSink()).doDeleteRightTuple(rightTuple, wm, bm);
            rightTuple = modifyPreviousTuples.peekRightTuple();
        }
        if (rightTuple != null && rightTuple.getInputOtnId().equals(this.getRightInputOtnId())) {
            modifyPreviousTuples.removeRightTuple();
            rightTuple.reAdd();
            if (context.getModificationMask().intersects(this.getRightInferredMask())) {
                rightTuple.setPropagationContext(context);
                bm = BetaNode.getBetaMemory(this, wm);
                rightTuple.setPropagationContext(context);
                this.doUpdateRightTuple(rightTuple, wm, bm);
            } else if (rightTuple.getMemory() != null) {
                BetaNode.getBetaMemory(this, wm).getRightTupleMemory().removeAdd(rightTuple);
            }
        } else if (context.getModificationMask().intersects(this.getRightInferredMask())) {
            this.assertObject(factHandle, context, wm);
        }
    }

    public void doDeleteRightTuple(RightTuple rightTuple, InternalWorkingMemory wm, BetaMemory memory) {
        TupleSets<RightTuple> stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedDeleteWasEmpty = stagedRightTuples.addDelete(rightTuple);
        boolean shouldFlush = this.isStreamMode();
        if (memory.getAndDecCounter() == 1) {
            if (stagedDeleteWasEmpty) {
                memory.setNodeDirtyWithoutNotify();
            }
            shouldFlush = memory.unlinkNode(wm) | shouldFlush;
        } else if (stagedDeleteWasEmpty) {
            shouldFlush = memory.setNodeDirty(wm) | shouldFlush;
        }
        if (shouldFlush) {
            AddRemoveRule.flushLeftTupleIfNecessary(wm, memory.getSegmentMemory(), this.isStreamMode());
        }
    }

    public void doUpdateRightTuple(RightTuple rightTuple, InternalWorkingMemory wm, BetaMemory memory) {
        TupleSets<RightTuple> stagedRightTuples = memory.getStagedRightTuples();
        boolean stagedUpdateWasEmpty = stagedRightTuples.addUpdate(rightTuple);
        boolean shouldFlush = this.isStreamMode();
        if (stagedUpdateWasEmpty) {
            shouldFlush = memory.setNodeDirty(wm) | shouldFlush;
        }
        if (shouldFlush) {
            AddRemoveRule.flushLeftTupleIfNecessary(wm, memory.getSegmentMemory(), this.isStreamMode());
        }
    }

    public boolean isRightInputIsRiaNode() {
        return this.rightInputIsRiaNode;
    }

    public boolean isRightInputPassive() {
        return this.rightInputIsPassive;
    }

    public ObjectSource getRightInput() {
        return this.rightInput;
    }

    public void setRightInput(ObjectSource rightInput) {
        this.rightInput = rightInput;
        this.rightInputIsRiaNode = 71 == rightInput.getType();
    }

    public FastIterator getRightIterator(TupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public FastIterator getRightIterator(TupleMemory memory, RightTuple rightTuple) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator(rightTuple);
    }

    public FastIterator getLeftIterator(TupleMemory memory) {
        if (!this.indexedUnificationJoin) {
            return memory.fastIterator();
        }
        return memory.fullFastIterator();
    }

    public RightTuple getFirstRightTuple(Tuple leftTuple, TupleMemory memory, InternalFactHandle factHandle, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return (RightTuple)memory.getFirst(leftTuple);
        }
        return (RightTuple)it.next(null);
    }

    public LeftTuple getFirstLeftTuple(RightTuple rightTuple, TupleMemory memory, FastIterator it) {
        if (!this.indexedUnificationJoin) {
            return (LeftTuple)memory.getFirst(rightTuple);
        }
        return (LeftTuple)it.next(null);
    }

    public static Tuple getFirstTuple(TupleMemory memory, FastIterator it) {
        if (!memory.isIndexed()) {
            return memory.getFirst(null);
        }
        return (Tuple)it.next(null);
    }

    public boolean isIndexedUnificationJoin() {
        return this.indexedUnificationJoin;
    }

    public BetaNodeFieldConstraint[] getConstraints() {
        return this.constraints.getConstraints();
    }

    public BetaConstraints getRawConstraints() {
        return this.constraints;
    }

    public void setConstraints(BetaConstraints constraints) {
        this.constraints = constraints.cloneIfInUse();
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        updateContext.startVisitNode(this.leftInput);
        this.rightInput.networkUpdated(updateContext);
        updateContext.endVisit();
        if (!updateContext.isVisiting(this.leftInput)) {
            this.leftInput.networkUpdated(updateContext);
        }
    }

    public List<String> getRules() {
        LeftTupleSink[] sinks;
        ArrayList<String> list = new ArrayList<String>();
        for (LeftTupleSink sink1 : sinks = this.sink.getSinks()) {
            if (sink1.getType() == 101) {
                list.add(((RuleTerminalNode)sink1).getRule().getName());
                continue;
            }
            if (!NodeTypeEnums.isBetaNode(sink1)) continue;
            list.addAll(((BetaNode)sink1).getRules());
        }
        return list;
    }

    @Override
    protected ObjectTypeNode getObjectTypeNode() {
        if (this.objectTypeNode == null) {
            ObjectSource source = this.rightInput;
            while (source != null) {
                if (source instanceof ObjectTypeNode) {
                    this.objectTypeNode = (ObjectTypeNode)source;
                    break;
                }
                source = source.source;
            }
        }
        return this.objectTypeNode;
    }

    @Override
    public void attach(BuildContext context) {
        this.constraints.init(context, this.getType());
        this.setUnificationJoin();
        this.rightInput.addObjectSink(this);
        this.leftInput.addTupleSink(this, context);
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        this.modifyObject(factHandle, modifyPreviousTuples, context, workingMemory);
    }

    public static BetaMemory getBetaMemory(BetaNode node, InternalWorkingMemory wm) {
        BetaMemory bm = node.getType() == 211 ? ((AccumulateNode.AccumulateMemory)wm.getNodeMemory(node)).getBetaMemory() : (BetaMemory)wm.getNodeMemory(node);
        return bm;
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemory;
    }

    @Override
    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    @Override
    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return this.constraints.createBetaMemory(config, this.getType());
    }

    @Override
    public String toString() {
        return "[ " + this.getClass().getSimpleName() + "(" + this.id + ") ]";
    }

    public void dumpMemory(InternalWorkingMemory workingMemory) {
        MemoryVisitor visitor = new MemoryVisitor(workingMemory);
        visitor.visit(this);
    }

    protected int calculateHashCode() {
        int hash = 23 * this.leftInput.hashCode() + 29 * this.rightInput.hashCode() + 31 * this.constraints.hashCode();
        if (this.leftListenedProperties != null) {
            hash += 37 * this.leftListenedProperties.hashCode();
        }
        if (this.rightListenedProperties != null) {
            hash += 41 * this.rightListenedProperties.hashCode();
        }
        return hash + (this.rightInputIsPassive ? 43 : 0);
    }

    public boolean equals(Object object) {
        return this == object || this.internalEquals(object) && this.leftInput.thisNodeEquals(((BetaNode)object).leftInput);
    }

    @Override
    protected boolean internalEquals(Object object) {
        if (object == null || !(object instanceof BetaNode) || this.hashCode() != object.hashCode()) {
            return false;
        }
        BetaNode other = (BetaNode)object;
        return this.getClass() == other.getClass() && this.constraints.equals(other.constraints) && this.rightInputIsPassive == other.rightInputIsPassive && ClassUtils.areNullSafeEquals(this.leftListenedProperties, other.leftListenedProperties) && ClassUtils.areNullSafeEquals(this.rightListenedProperties, other.rightListenedProperties) && this.rightInput.getId() == other.rightInput.getId();
    }

    @Override
    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    @Override
    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    @Override
    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    @Override
    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    @Override
    public ObjectSinkNode getNextObjectSinkNode() {
        return this.nextObjectSinkNode;
    }

    @Override
    public void setNextObjectSinkNode(ObjectSinkNode next) {
        this.nextObjectSinkNode = next;
    }

    @Override
    public ObjectSinkNode getPreviousObjectSinkNode() {
        return this.previousObjectSinkNode;
    }

    @Override
    public void setPreviousObjectSinkNode(ObjectSinkNode previous) {
        this.previousObjectSinkNode = previous;
    }

    public RightTuple createRightTuple(InternalFactHandle handle, RightTupleSink sink, PropagationContext context) {
        RightTupleImpl rightTuple = new RightTupleImpl(handle, sink);
        rightTuple.setPropagationContext(context);
        return rightTuple;
    }

    public static BetaMemory getBetaMemoryFromRightInput(BetaNode betaNode, InternalWorkingMemory workingMemory) {
        BetaMemory memory;
        BetaMemory betaMemory = memory = 211 == betaNode.getType() ? ((AccumulateNode.AccumulateMemory)workingMemory.getNodeMemory(betaNode)).getBetaMemory() : (BetaMemory)workingMemory.getNodeMemory(betaNode);
        if (memory.getSegmentMemory() == null) {
            SegmentUtilities.createSegmentMemory(betaNode, workingMemory);
        }
        return memory;
    }

    public BitMask getRightDeclaredMask() {
        return this.rightDeclaredMask;
    }

    public void setRightDeclaredMask(BitMask rightDeclaredMask) {
        this.rightDeclaredMask = rightDeclaredMask;
    }

    public BitMask getRightInferredMask() {
        return this.rightInferredMask;
    }

    public BitMask getRightNegativeMask() {
        return this.rightNegativeMask;
    }

    @Override
    public ObjectTypeNode.Id getRightInputOtnId() {
        return this.rightInputOtnId;
    }

    public void setRightInputOtnId(ObjectTypeNode.Id rightInputOtnId) {
        this.rightInputOtnId = rightInputOtnId;
    }
}

