/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.kie.eclipse.utils.PreferencesUtils;

public class LoginDialog
extends Dialog {
    private Text usernameText;
    private Text passwordText;
    private URIish uri;
    private String username;
    private String password;

    public LoginDialog(Shell shell, URIish uri) {
        super(shell);
        this.uri = uri;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.getShell().setText("Login");
        Label uriLabel = new Label(composite, 0);
        uriLabel.setText("Repository:");
        uriLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        final Text uriText = new Text(composite, 8);
        uriText.setText(this.uri.toString());
        GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
        GC gc = new GC((Drawable)uriText);
        int x = gc.stringExtent((String)uriText.getText()).x;
        gd.minimumWidth = x + x / 2;
        uriText.setLayoutData((Object)gd);
        Label usernameLabel = new Label(composite, 0);
        usernameLabel.setText("Username");
        this.usernameText = new Text(composite, 2048);
        if (this.username != null) {
            this.usernameText.setText(this.username);
        }
        this.usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LoginDialog.this.username = LoginDialog.this.usernameText.getText();
                String path = LoginDialog.this.uri.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                LoginDialog.this.uri = PreferencesUtils.getRepoURI((String)LoginDialog.this.uri.getHost(), (int)LoginDialog.this.uri.getPort(), (String)LoginDialog.this.username, (String)path);
                uriText.setText(LoginDialog.this.uri.toString());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.usernameText);
        Label passwordLabel = new Label(composite, 0);
        passwordLabel.setText("Password");
        this.passwordText = new Text(composite, 0x400800);
        if (this.password != null) {
            this.passwordText.setText(this.password);
        }
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.passwordText);
        return composite;
    }

    protected void okPressed() {
        if (this.usernameText.getText().length() > 0) {
            this.username = this.usernameText.getText();
            this.password = this.passwordText.getText();
        }
        super.okPressed();
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

