/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.organization;

import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.server.IKieOrganizationHandler;
import org.kie.eclipse.server.IKieRepositoryHandler;
import org.kie.eclipse.server.IKieServerHandler;
import org.kie.eclipse.server.IKieServiceDelegate;

public class AddRepositoryAction
extends KieNavigatorAction {
    protected AddRepositoryAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public AddRepositoryAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Add Repository...");
    }

    public void run() {
        IContainerNode<?> container = this.getContainer();
        if (container == null) {
            return;
        }
        IKieOrganizationHandler organization = (IKieOrganizationHandler)container.getHandler();
        IKieServerHandler server = (IKieServerHandler)container.getRoot().getHandler();
        IKieServiceDelegate delegate = this.getDelegate();
        try {
            List allRepositories = delegate.getRepositories(server);
            for (IKieOrganizationHandler org : delegate.getOrganizations(server)) {
                block5: for (IKieRepositoryHandler rep : org.getRepositories()) {
                    for (IKieRepositoryHandler ar : allRepositories) {
                        if (!ar.getName().equals(rep.getName())) continue;
                        allRepositories.remove(ar);
                        continue block5;
                    }
                }
            }
            if (allRepositories.isEmpty()) {
                MessageDialog.openInformation((Shell)AddRepositoryAction.getShell(), (String)"No Repositories", (String)"All known Repositories are already assigned to other Organizational Units.");
            } else {
                Object[] result;
                ListDialog dlg = new ListDialog(AddRepositoryAction.getShell());
                dlg.setContentProvider(new IStructuredContentProvider(){

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }

                    public Object[] getElements(Object inputElement) {
                        return ((List)inputElement).toArray();
                    }
                });
                dlg.setLabelProvider(new ILabelProvider(){

                    public void removeListener(ILabelProviderListener listener) {
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return false;
                    }

                    public void dispose() {
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public String getText(Object element) {
                        return ((IKieRepositoryHandler)element).getName();
                    }

                    public Image getImage(Object element) {
                        return null;
                    }
                });
                dlg.setInput((Object)allRepositories);
                dlg.setMessage("Select a Repository to add to Organizational Unit " + organization.getName());
                dlg.setTitle("Add Repository to Organizationl Unit");
                if (dlg.open() == 0 && (result = dlg.getResult()).length == 1) {
                    try {
                        delegate.addRepository((IKieRepositoryHandler)result[0], organization);
                        AddRepositoryAction.refreshViewer(container.getRoot());
                    }
                    catch (Exception e) {
                        this.handleException(e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }
}

