/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.content;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.kie.eclipse.navigator.view.content.ContentNode;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.IErrorNode;
import org.kie.eclipse.server.IKieResourceHandler;
import org.kie.eclipse.server.KieResourceHandler;

public class ErrorNode
extends ContentNode<IContainerNode<?>>
implements IErrorNode {
    public static final String ERROR_TYPE = "error";
    private final String text;
    private Exception exception;

    protected ErrorNode(IContainerNode<?> parent, String text) {
        super(parent, (IKieResourceHandler)new ErrorHandler(text));
        this.text = text;
    }

    protected ErrorNode(IContainerNode<?> parent, Exception exception) {
        super(parent, (IKieResourceHandler)new ErrorHandler("Error"));
        this.text = "Error";
        this.exception = exception;
    }

    @Override
    public String getText() {
        if (this.exception != null) {
            String msg = this.exception.getMessage();
            if (msg == null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter((Writer)sw, true);
                this.exception.printStackTrace(pw);
                pw.close();
                String[] s = sw.toString().split(System.getProperty("line.separator"));
                if (s.length > 1) {
                    msg = String.valueOf(s[0]) + " : " + s[1];
                }
            }
            return msg;
        }
        return this.text;
    }

    @Override
    public boolean equals(Object obj) {
        return false;
    }

    private static final class ErrorHandler
    extends KieResourceHandler {
        public ErrorHandler(String text) {
            super(null, text);
        }

        public List<? extends IKieResourceHandler> getChildren() throws Exception {
            return null;
        }
    }
}

