/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.compiler.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.SemanticModules;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.kie.api.definition.process.Process;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlProcessReader {
    private ExtensibleXmlParser parser;
    private List<Process> processes;

    public XmlProcessReader(SemanticModules modules, ClassLoader classLoader) {
        this(modules, classLoader, null);
    }

    public XmlProcessReader(SemanticModules modules, ClassLoader classLoader, SAXParser parser) {
        this.parser = parser == null ? new ExtensibleXmlParser() : new ExtensibleXmlParser(parser);
        this.parser.setSemanticModules(modules);
        this.parser.setData((Object)new ProcessBuildData());
        this.parser.setClassLoader(classLoader);
    }

    public List<Process> read(Reader reader) throws SAXException, IOException {
        this.processes = ((ProcessBuildData)this.parser.read(reader)).getProcesses();
        return this.processes;
    }

    public List<Process> read(InputStream inputStream) throws SAXException, IOException {
        this.processes = ((ProcessBuildData)this.parser.read(inputStream)).getProcesses();
        return this.processes;
    }

    public List<Process> read(InputSource in) throws SAXException, IOException {
        this.processes = ((ProcessBuildData)this.parser.read(in)).getProcesses();
        return this.processes;
    }

    void setProcesses(List<Process> processes) {
        this.processes = processes;
    }

    public List<Process> getProcess() {
        return this.processes;
    }

    public ProcessBuildData getProcessBuildData() {
        return (ProcessBuildData)this.parser.getData();
    }
}

