/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.util.ArrayList;
import java.util.List;
import org.drools.compiler.lang.descr.AnnotatedBaseDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ConditionalElementDescr;
import org.drools.compiler.lang.descr.PatternDescr;

public class AndDescr
extends AnnotatedBaseDescr
implements ConditionalElementDescr {
    private static final long serialVersionUID = 510L;
    private List<BaseDescr> descrs = new ArrayList<BaseDescr>();

    @Override
    public void addDescr(BaseDescr baseDescr) {
        this.descrs.add(baseDescr);
    }

    public void insertDescr(int index, BaseDescr baseDescr) {
        this.descrs.add(index, baseDescr);
    }

    @Override
    public void insertBeforeLast(Class<?> clazz, BaseDescr baseDescr) {
        if (this.descrs.isEmpty()) {
            this.addDescr(baseDescr);
            return;
        }
        for (int i = this.descrs.size() - 1; i >= 0; --i) {
            if (!clazz.isInstance(this.descrs.get(i))) continue;
            this.insertDescr(i, baseDescr);
            return;
        }
        this.addDescr(baseDescr);
    }

    public List<BaseDescr> getDescrs() {
        return this.descrs;
    }

    public List<PatternDescr> getAllPatternDescr() {
        ArrayList<PatternDescr> patterns = new ArrayList<PatternDescr>();
        this.getAllPatternDescr(this, patterns);
        return patterns;
    }

    private void getAllPatternDescr(ConditionalElementDescr elementDescr, List<PatternDescr> patterns) {
        for (BaseDescr baseDescr : elementDescr.getDescrs()) {
            if (baseDescr instanceof PatternDescr) {
                patterns.add((PatternDescr)baseDescr);
                continue;
            }
            if (!(baseDescr instanceof ConditionalElementDescr)) continue;
            this.getAllPatternDescr((ConditionalElementDescr)((Object)baseDescr), patterns);
        }
    }

    @Override
    public void addOrMerge(BaseDescr baseDescr) {
        if (baseDescr instanceof AndDescr) {
            AndDescr and = (AndDescr)baseDescr;
            for (BaseDescr descr : and.getDescrs()) {
                this.addDescr(descr);
            }
            for (String annKey : and.getAnnotationNames()) {
                this.addAnnotation(and.getAnnotation(annKey));
            }
        } else {
            this.addDescr(baseDescr);
        }
    }

    @Override
    public boolean removeDescr(BaseDescr baseDescr) {
        return baseDescr == null ? false : this.descrs.remove(baseDescr);
    }

    public String toString() {
        return "[AND " + this.descrs + " ]";
    }
}

