/*
 * Decompiled with CFR 0.152.
 */
package org.kie.eclipse.navigator.view.actions.repository;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.kie.eclipse.navigator.view.actions.KieNavigatorAction;
import org.kie.eclipse.navigator.view.content.IContainerNode;
import org.kie.eclipse.navigator.view.content.RepositoryNode;
import org.kie.eclipse.navigator.view.utils.ActionUtils;
import org.kie.eclipse.server.KieRepositoryHandler;

public class ImportRepositoryAction
extends KieNavigatorAction {
    protected ImportRepositoryAction(ISelectionProvider provider, String text) {
        super(provider, text);
    }

    public ImportRepositoryAction(ISelectionProvider selectionProvider) {
        this(selectionProvider, "Import Repository");
    }

    public boolean isEnabled() {
        KieRepositoryHandler handler;
        IContainerNode<?> container = this.getContainer();
        return container instanceof RepositoryNode && ((handler = (KieRepositoryHandler)((RepositoryNode)container).getHandler()) == null || !handler.isLoaded());
    }

    public String getToolTipText() {
        return "Clone this Git Repository from the remote server";
    }

    public void run() {
        RepositoryNode container = (RepositoryNode)this.getContainer();
        if (container == null) {
            return;
        }
        try {
            ActionUtils.importRepository(this, container);
            container.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

